/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.util;

import de.spricom.dessert.util.Predicate;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> any() {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return true;
            }
        };
    }

    public static <T> Predicate<T> none() {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return false;
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<T> ... predicates) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate predicate : predicates) {
                    if (predicate.test(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<T> ... predicates) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> not(final Predicate<T> predicate) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return !predicate.test(t);
            }
        };
    }
}

