package de.spricom.dessert.modules.java;

/*-
 * #%L
 * Dessert Dependency Assertion Library for Java
 * %%
 * Copyright (C) 2017 - 2023 Hans Jörg Heßmann
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
import de.spricom.dessert.modules.core.FixedModule;
import de.spricom.dessert.slicing.Classpath;
import de.spricom.dessert.slicing.Slices;

/**
 * Generated by de.spricom.dessert.tools.GenerateStaticModulesTool.
 */
class ManagementModule extends FixedModule {

    ManagementModule(Classpath cp) {
        super("java.management", "17",
                Slices.of(
                        cp.slice("java.lang.management.*"),
                        cp.slice("javax.management.*"),
                        cp.slice("javax.management.loading.*"),
                        cp.slice("javax.management.modelmbean.*"),
                        cp.slice("javax.management.monitor.*"),
                        cp.slice("javax.management.openmbean.*"),
                        cp.slice("javax.management.relation.*"),
                        cp.slice("javax.management.remote.*"),
                        cp.slice("javax.management.timer.*")
                ),
                Slices.of(
                        cp.slice("com.sun.jmx.defaults.*"),
                        cp.slice("com.sun.jmx.interceptor.*"),
                        cp.slice("com.sun.jmx.mbeanserver.*"),
                        cp.slice("com.sun.jmx.remote.internal.*"),
                        cp.slice("com.sun.jmx.remote.security.*"),
                        cp.slice("com.sun.jmx.remote.util.*"),
                        cp.slice("java.lang.management.*"),
                        cp.slice("javax.management.*"),
                        cp.slice("javax.management.loading.*"),
                        cp.slice("javax.management.modelmbean.*"),
                        cp.slice("javax.management.monitor.*"),
                        cp.slice("javax.management.openmbean.*"),
                        cp.slice("javax.management.relation.*"),
                        cp.slice("javax.management.remote.*"),
                        cp.slice("javax.management.timer.*"),
                        cp.slice("sun.management.*"),
                        cp.slice("sun.management.counter.*"),
                        cp.slice("sun.management.counter.perf.*"),
                        cp.slice("sun.management.spi.*")
                ));
    }
}
