/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.assertions;

import de.spricom.dessert.assertions.IllegalDependencies;
import de.spricom.dessert.assertions.IllegalDependenciesRenderer;
import de.spricom.dessert.slicing.Clazz;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DefaultIllegalDependenciesRenderer
implements IllegalDependenciesRenderer {
    @Override
    public String render(IllegalDependencies violations) {
        Map<Clazz, Set<Clazz>> dependencyViolations = violations.getViolations();
        StringBuilder sb = new StringBuilder("Illegal Dependencies:\n");
        for (Clazz clazz : this.sort(dependencyViolations.keySet())) {
            sb.append(clazz.getName()).append("\n");
            for (Clazz dep : dependencyViolations.get(clazz)) {
                sb.append(" -> ").append(dep.getName()).append("\n");
            }
        }
        return sb.toString();
    }

    private Collection<Clazz> sort(Set<Clazz> entries) {
        TreeMap<String, Clazz> sorted = new TreeMap<String, Clazz>();
        for (Clazz entry : entries) {
            sorted.put(entry.getName(), entry);
        }
        return sorted.values();
    }
}

