/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.attribute.ExceptionTableEntry;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class CodeAttribute
extends AttributeInfo {
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private ExceptionTableEntry[] exceptionTable;
    private AttributeInfo[] attributes;

    public CodeAttribute(String name, DataInputStream is, ConstantPool constantPool) throws IOException {
        super(name);
        is.readInt();
        this.maxStack = is.readUnsignedShort();
        this.maxLocals = is.readUnsignedShort();
        this.code = new byte[is.readInt()];
        is.readFully(this.code);
        this.exceptionTable = new ExceptionTableEntry[is.readUnsignedShort()];
        for (int i = 0; i < this.exceptionTable.length; ++i) {
            ExceptionTableEntry entry = new ExceptionTableEntry();
            entry.setStartPc(is.readUnsignedShort());
            entry.setEndPc(is.readUnsignedShort());
            entry.setHandlerPc(is.readUnsignedShort());
            entry.setCatchType(constantPool.getConstantClassName(is.readUnsignedShort()));
            this.exceptionTable[i] = entry;
        }
        this.setAttributes(AttributeInfo.readAttributes(is, constantPool, AttributeInfo.AttributeContext.CODE));
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] code) {
        this.code = code;
    }

    public ExceptionTableEntry[] getExceptionTable() {
        return this.exceptionTable;
    }

    public void setExceptionTable(ExceptionTableEntry[] exceptionTable) {
        this.exceptionTable = exceptionTable;
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeInfo[] attributes) {
        this.attributes = attributes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(super.toString());
        for (AttributeInfo attribute : this.attributes) {
            sb.append("\n\t\t\t\t").append(attribute);
        }
        return sb.toString();
    }
}

