/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import de.spricom.dessert.classfile.constpool.MethodType;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public class EnclosingMethodAttribute
extends AttributeInfo {
    private final String enclosingClassname;
    private final String enclosingMethodName;
    private final MethodType enclosingMethodType;

    public EnclosingMethodAttribute(String name, DataInputStream is, ConstantPool constantPool) throws IOException {
        super(name);
        this.skipLength(is);
        this.enclosingClassname = constantPool.getConstantClassName(is.readUnsignedShort());
        int enclosingMethodIndex = is.readUnsignedShort();
        if (enclosingMethodIndex == 0) {
            this.enclosingMethodName = null;
            this.enclosingMethodType = null;
        } else {
            this.enclosingMethodName = constantPool.getNameAndTypeName(enclosingMethodIndex);
            this.enclosingMethodType = constantPool.getNameAndTypeMethodType(enclosingMethodIndex);
        }
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        if (this.enclosingMethodType != null) {
            this.enclosingMethodType.addDependentClassNames(classNames);
        }
    }

    public String getEnclosingClassname() {
        return this.enclosingClassname;
    }

    public String getEnclosingMethodName() {
        return this.enclosingMethodName;
    }

    public MethodType getEnclosingMethodType() {
        return this.enclosingMethodType;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.enclosingClassname + "." + (this.enclosingMethodName == null ? "<init>" : this.enclosingMethodName + this.enclosingMethodType);
    }
}

