/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.constpool;

import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.util.Set;
import java.util.regex.Pattern;

public class FieldType
implements DependencyHolder {
    private static final Pattern DESCRIPTOR_PATTERN = Pattern.compile("\\[*([BCDFIJSZ]|L\\S+;)");
    private Class<?> primitiveType;
    private String objectTypeClassname;
    private int arrayDimensions;

    public FieldType(String descriptor) {
        int i = 0;
        while (descriptor.charAt(i) == '[') {
            ++this.arrayDimensions;
            ++i;
        }
        switch (descriptor.charAt(i)) {
            case 'B': {
                this.primitiveType = Byte.TYPE;
                break;
            }
            case 'C': {
                this.primitiveType = Character.TYPE;
                break;
            }
            case 'D': {
                this.primitiveType = Double.TYPE;
                break;
            }
            case 'F': {
                this.primitiveType = Float.TYPE;
                break;
            }
            case 'I': {
                this.primitiveType = Integer.TYPE;
                break;
            }
            case 'J': {
                this.primitiveType = Long.TYPE;
                break;
            }
            case 'L': {
                this.objectTypeClassname = descriptor.substring(i + 1, descriptor.indexOf(59, i + 1)).replace('/', '.');
                break;
            }
            case 'S': {
                this.primitiveType = Short.TYPE;
                break;
            }
            case 'V': {
                this.primitiveType = Void.TYPE;
                break;
            }
            case 'Z': {
                this.primitiveType = Boolean.TYPE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid field descriptor: " + descriptor);
            }
        }
    }

    public int getDescriptorLength() {
        if (this.isPrimitiveType()) {
            return this.arrayDimensions + 1;
        }
        return this.arrayDimensions + this.objectTypeClassname.length() + 2;
    }

    public boolean isArrayType() {
        return this.arrayDimensions > 0;
    }

    public boolean isPrimitiveType() {
        return this.primitiveType != null && !this.isVoidType();
    }

    public boolean isVoidType() {
        return Void.TYPE == this.primitiveType;
    }

    public boolean isObjectType() {
        return this.primitiveType == null;
    }

    public String getDeclaration() {
        StringBuilder sb = new StringBuilder();
        if (this.primitiveType != null) {
            sb.append(this.primitiveType.getName());
        } else {
            sb.append(this.objectTypeClassname);
        }
        for (int i = 0; i < this.arrayDimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    @Override
    public final void addDependentClassNames(Set<String> classNames) {
        if (this.isObjectType()) {
            classNames.add(this.getObjectTypeClassname());
        }
    }

    public static boolean isFieldDescriptor(String descriptor) {
        return DESCRIPTOR_PATTERN.matcher(descriptor).matches();
    }

    public String toString() {
        return this.getDeclaration();
    }

    public String getObjectTypeClassname() {
        return this.objectTypeClassname;
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public Class<?> getPrimitiveType() {
        return this.primitiveType;
    }
}

