/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.constpool;

import de.spricom.dessert.classfile.constpool.FieldType;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;

public class MethodType
implements DependencyHolder {
    private static final Pattern DESCRIPTOR_PATTERN = Pattern.compile("\\((\\[*([BCDFIJSZ]|L\\S+;))*\\)\\[*([BCDFIJSVZ]|L\\S+;)");
    private final FieldType[] parameterTypes;
    private final FieldType returnType;

    public MethodType(String descriptor) {
        assert (descriptor != null) : "descriptor == null";
        if ('(' != descriptor.charAt(0)) {
            throw new IllegalArgumentException("Invalid method descriptor: " + descriptor);
        }
        ArrayList<FieldType> params = new ArrayList<FieldType>();
        int index = 1;
        while (')' != descriptor.charAt(index)) {
            FieldType param = new FieldType(descriptor.substring(index));
            params.add(param);
            index += param.getDescriptorLength();
        }
        this.parameterTypes = params.toArray(new FieldType[0]);
        this.returnType = new FieldType(descriptor.substring(++index));
    }

    @Override
    public final void addDependentClassNames(Set<String> classNames) {
        for (FieldType parameterType : this.parameterTypes) {
            parameterType.addDependentClassNames(classNames);
        }
        this.returnType.addDependentClassNames(classNames);
    }

    public static boolean isMethodDescriptor(String descriptor) {
        return DESCRIPTOR_PATTERN.matcher(descriptor).matches();
    }

    public FieldType[] getParameterTypes() {
        return this.parameterTypes;
    }

    public FieldType getReturnType() {
        return this.returnType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (FieldType parameterType : this.parameterTypes) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(parameterType);
        }
        sb.append(") -> ");
        sb.append(this.returnType);
        return sb.toString();
    }
}

