/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.modules;

import de.spricom.dessert.modules.core.ModuleLookup;
import de.spricom.dessert.modules.core.ModuleResolver;
import de.spricom.dessert.modules.core.ModuleSlice;
import de.spricom.dessert.modules.java.JavaModulesResolver;
import de.spricom.dessert.modules.jdk.JdkModulesResolver;
import de.spricom.dessert.modules.jpms.JavaPlatformModuleResolver;
import de.spricom.dessert.resolve.ClassResolver;
import de.spricom.dessert.slicing.Classpath;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ModuleRegistry
implements ModuleResolver,
ModuleLookup {
    private static final Logger log = Logger.getLogger(ModuleRegistry.class.getName());
    private final Map<String, ModuleSlice> modules = new HashMap<String, ModuleSlice>();

    public ModuleRegistry(ModuleResolver ... resolvers) {
        for (ModuleResolver resolver : resolvers) {
            this.addAll(resolver);
        }
    }

    public ModuleRegistry(Classpath cp) {
        this(ModuleRegistry.defaultResolvers(cp));
    }

    private static ModuleResolver[] defaultResolvers(Classpath cp) {
        if (ModuleRegistry.isJavaPlattformModuleSystemAvailable()) {
            return new ModuleResolver[]{new JavaPlatformModuleResolver(cp)};
        }
        return new ModuleResolver[]{new JavaPlatformModuleResolver(cp), new JavaModulesResolver(cp), new JdkModulesResolver(cp)};
    }

    public static boolean isJavaPlattformModuleSystemAvailable() {
        return ClassResolver.isJrtFileSystemAvailable();
    }

    public Collection<ModuleSlice> getModules() {
        return this.getModuleMap().values();
    }

    public Collection<String> getModuleNames() {
        return this.getModuleMap().keySet();
    }

    private Map<String, ModuleSlice> getModuleMap() {
        return Collections.unmodifiableMap(this.modules);
    }

    @Override
    public ModuleSlice getModule(String name) {
        return this.modules.get(name);
    }

    private boolean add(ModuleSlice module) {
        String name = module.getName();
        ModuleSlice previous = this.modules.get(name);
        if (previous == null) {
            this.modules.put(name, module);
            return true;
        }
        if (!previous.equals(module)) {
            log.log(Level.WARNING, "There are two modules named ''{0}''", name);
        }
        return false;
    }

    private boolean addAll(ModuleResolver resolver) {
        boolean modified = false;
        for (ModuleSlice moduleSlice : resolver.getModules()) {
            modified |= this.add(moduleSlice);
        }
        return modified;
    }
}

