/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.partitioning;

import de.spricom.dessert.classfile.ClassFile;
import de.spricom.dessert.classfile.FieldInfo;
import de.spricom.dessert.classfile.MemberInfo;
import de.spricom.dessert.classfile.MethodInfo;
import de.spricom.dessert.classfile.attribute.AbstractAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.AbstractParameterAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.AbstractTypeAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.Annotation;
import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.attribute.Attributes;
import de.spricom.dessert.classfile.attribute.CodeAttribute;
import de.spricom.dessert.classfile.attribute.ElementValue;
import de.spricom.dessert.classfile.attribute.ElementValuePair;
import de.spricom.dessert.classfile.attribute.ParameterAnnotation;
import de.spricom.dessert.classfile.attribute.RecordAttribute;
import de.spricom.dessert.classfile.attribute.TypeAnnotation;
import de.spricom.dessert.util.AnnotationPattern;
import de.spricom.dessert.util.Predicate;
import java.util.BitSet;
import java.util.Map;

class AnnotationMatcher
implements Predicate<ClassFile> {
    private final AnnotationPattern pattern;

    AnnotationMatcher(AnnotationPattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean test(ClassFile classFile) {
        if (this.matchesAny(classFile.getAttributes())) {
            return true;
        }
        for (FieldInfo fieldInfo : classFile.getFields()) {
            if (!this.matchesAny(fieldInfo.getAttributes())) continue;
            return true;
        }
        for (MemberInfo memberInfo : classFile.getMethods()) {
            if (this.matchesAny(((MethodInfo)memberInfo).getAttributes())) {
                return true;
            }
            for (CodeAttribute code : Attributes.filter(classFile.getAttributes(), CodeAttribute.class)) {
                if (!this.matchesAny(code.getAttributes())) continue;
                return true;
            }
        }
        for (RecordAttribute record : Attributes.filter(classFile.getAttributes(), RecordAttribute.class)) {
            for (RecordAttribute.RecordComponentInfo component : record.getComponents()) {
                if (!this.matchesAny(component.getAttributes())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesAny(AttributeInfo[] attributes) {
        for (AttributeInfo attribute : attributes) {
            AttributeInfo annotationsAttribute;
            if (attribute instanceof AbstractAnnotationsAttribute) {
                annotationsAttribute = (AbstractAnnotationsAttribute)attribute;
                if (!this.matchesAny(((AbstractAnnotationsAttribute)annotationsAttribute).getAnnotations())) continue;
                return true;
            }
            if (attribute instanceof AbstractParameterAnnotationsAttribute) {
                annotationsAttribute = (AbstractParameterAnnotationsAttribute)attribute;
                for (ParameterAnnotation parameterAnnotation : ((AbstractParameterAnnotationsAttribute)annotationsAttribute).getParameterAnnotations()) {
                    if (!this.matchesAny(parameterAnnotation.getAnnotations())) continue;
                    return true;
                }
                continue;
            }
            if (!(attribute instanceof AbstractTypeAnnotationsAttribute) || !this.matchesAny(((AbstractTypeAnnotationsAttribute)(annotationsAttribute = (AbstractTypeAnnotationsAttribute)attribute)).getTypeAnnotations())) continue;
            return true;
        }
        return false;
    }

    private boolean matchesAny(TypeAnnotation[] typeAnnotations) {
        for (TypeAnnotation typeAnnotation : typeAnnotations) {
            if (!this.matches(typeAnnotation.getAnnotation())) continue;
            return true;
        }
        return false;
    }

    private boolean matchesAny(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!this.matches(annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Annotation annotation) {
        if (!annotation.getType().getObjectTypeClassname().equals(this.pattern.getAnnotationClassName())) {
            return false;
        }
        for (Map.Entry<String, Object> member : this.pattern.getAnnotationMembers().entrySet()) {
            if (this.hasMember(annotation, member.getKey(), member.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean hasMember(Annotation annotation, String key, Object value) {
        for (ElementValuePair elementValuePair : annotation.getElementValuePairs()) {
            if (!key.equals(elementValuePair.getName())) continue;
            return this.matches(elementValuePair.getValue(), value);
        }
        return false;
    }

    private boolean matches(ElementValue value, Object patternValue) {
        switch (value.getTag()) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 's': {
                return patternValue.equals(value.getConstantValue().getValue());
            }
            case 'Z': {
                return patternValue.equals(Integer.valueOf(1).equals(value.getConstantValue().getValue()));
            }
            case 'e': {
                return patternValue.getClass().getName().equals(value.getType().getDeclaration()) && patternValue.toString().equals(value.getConstantValue().getValue());
            }
            case 'c': {
                return ((Class)patternValue).getName().equals(value.getType().getDeclaration());
            }
            case '@': {
                return new AnnotationMatcher((AnnotationPattern)patternValue).matches(value.getAnnotation());
            }
            case '[': {
                return this.matches(value.getValues(), patternValue);
            }
        }
        throw new IllegalArgumentException("Invalid ElementValue tag: " + value.getTag());
    }

    private boolean matches(ElementValue[] values, Object patternValue) {
        Object[] objectArray;
        if (patternValue instanceof Object[]) {
            objectArray = (Object[])patternValue;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = patternValue;
        }
        Object[] patternValues = objectArray;
        if (values.length != patternValues.length) {
            return false;
        }
        BitSet matches = new BitSet(patternValues.length);
        block0: for (ElementValue value : values) {
            int i = matches.nextClearBit(0);
            while (i < patternValues.length) {
                if (this.matches(value, patternValues[i])) {
                    matches.set(i);
                    continue block0;
                }
                i = matches.nextClearBit(i + 1);
            }
        }
        return matches.cardinality() == patternValues.length;
    }
}

