/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.classfile.ClassFile;
import de.spricom.dessert.resolve.ClassPackage;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class ClassEntry {
    private final String classname;
    private final ClassPackage pckg;
    private final Integer version;
    private List<ClassEntry> alternatives;
    private ClassFile classFile;

    protected ClassEntry(String classname, ClassPackage pckg) {
        this(classname, pckg, null);
    }

    protected ClassEntry(String classname, ClassPackage pckg, Integer version) {
        this.classname = classname;
        this.pckg = pckg;
        this.version = version;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getShortName() {
        if (this.pckg.getPackageName().isEmpty()) {
            return this.classname;
        }
        return this.classname.substring(this.getPackage().getPackageName().length() + 1);
    }

    public ClassFile getClassfile() {
        if (this.classFile == null) {
            this.classFile = this.resolveClassFile();
            assert (this.classname.equals(this.classFile.getThisClass())) : this.classname + " != " + this.classFile.getThisClass();
        }
        return this.classFile;
    }

    protected abstract ClassFile resolveClassFile();

    public ClassPackage getPackage() {
        return this.pckg;
    }

    public List<ClassEntry> getAlternatives() {
        return this.alternatives;
    }

    public List<ClassEntry> getAlternativesWithinSamePackage() {
        if (this.alternatives == null) {
            return Collections.emptyList();
        }
        LinkedList<ClassEntry> versioned = new LinkedList<ClassEntry>();
        for (ClassEntry alternative : this.alternatives) {
            if (alternative.getPackage() != this.pckg) continue;
            versioned.add(alternative);
        }
        return versioned;
    }

    void addAlternative(ClassEntry alt) {
        assert (alt.alternatives == null) : "alt.alternatives != null";
        if (this.alternatives == null) {
            this.alternatives = new LinkedList<ClassEntry>();
            this.alternatives.add(this);
        }
        assert (!this.alternatives.contains(alt)) : "alternatives.contains(alt)";
        this.alternatives.add(alt);
        alt.alternatives = this.alternatives;
    }

    public Integer getVersion() {
        return this.version;
    }

    public abstract URI getURI();
}

