/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.matching.ShortNameMatcher;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassRoot;
import de.spricom.dessert.resolve.ClassVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class ClassPackage {
    private static final Logger log = Logger.getLogger(ClassPackage.class.getName());
    private final String packageName;
    private final ClassPackage parent;
    private final Map<String, ClassPackage> subPackages = new TreeMap<String, ClassPackage>();
    private final Map<String, ClassEntry> classes = new TreeMap<String, ClassEntry>();
    private List<ClassPackage> alternatives;

    protected ClassPackage() {
        this.packageName = "";
        this.parent = null;
    }

    public ClassPackage(ClassPackage parent, String packageName) {
        this.parent = parent;
        this.packageName = packageName;
        if (parent.subPackages.put(packageName, this) != null) {
            log.warning(packageName + " appears twice.");
        }
    }

    public ClassPackage getParent() {
        return this.parent;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getClassName(String simpleName) {
        return this.packageName.isEmpty() ? simpleName : this.packageName + "." + simpleName;
    }

    public String getShortName() {
        if (this.parent == null) {
            return "";
        }
        String parentPackageName = this.getParent().getPackageName();
        if (parentPackageName.isEmpty()) {
            return this.packageName;
        }
        return this.packageName.substring(parentPackageName.length() + 1);
    }

    public ClassRoot getRoot() {
        return this.parent.getRoot();
    }

    @Deprecated
    public File getRootFile() {
        return this.getRoot().getRootFile();
    }

    public String toString() {
        return this.packageName;
    }

    public List<ClassPackage> getSubPackages() {
        return new ArrayList<ClassPackage>(this.subPackages.values());
    }

    public ClassPackage getSubPackage(String packageName) {
        return this.subPackages.get(packageName);
    }

    public List<ClassEntry> getClasses() {
        return new ArrayList<ClassEntry>(this.classes.values());
    }

    public void addClass(ClassEntry ce) {
        ClassEntry previous = this.classes.get(ce.getClassname());
        if (previous == null || previous.getVersion() != null && ce.getVersion() == null) {
            this.classes.put(ce.getClassname(), ce);
        } else if (previous.getVersion() == null && ce.getVersion() == null) {
            log.warning(ce.getURI() + " appears twice, using first one.");
        }
    }

    public ClassEntry getClass(String classname) {
        return this.classes.get(classname);
    }

    public List<ClassPackage> getAlternatives() {
        return this.alternatives;
    }

    void addAlternative(ClassPackage alt) {
        assert (alt.alternatives == null) : "alt.alternatives != null";
        if (this.alternatives == null) {
            this.alternatives = new LinkedList<ClassPackage>();
            this.alternatives.add(this);
        }
        assert (!this.alternatives.contains(alt)) : "alternatives.contains(alt)";
        this.alternatives.add(alt);
        alt.alternatives = this.alternatives;
    }

    protected final void traverse(ShortNameMatcher matcher, ClassVisitor visitor) {
        if (!matcher.isMatchPossible()) {
            return;
        }
        if (matcher.isLast()) {
            this.traverseClasses(matcher, visitor);
        } else {
            this.traverseSubPackages(matcher, visitor);
            if (matcher.isWildcard()) {
                this.traverse(matcher.next(), visitor);
            }
        }
    }

    private void traverseClasses(ShortNameMatcher matcher, ClassVisitor visitor) {
        for (ClassEntry clazz : this.classes.values()) {
            if (!matcher.match(clazz.getShortName()).matches()) continue;
            visitor.visit(clazz);
            for (ClassEntry versionedAlternative : clazz.getAlternativesWithinSamePackage()) {
                visitor.visit(versionedAlternative);
            }
        }
    }

    private void traverseSubPackages(ShortNameMatcher matcher, ClassVisitor visitor) {
        for (ClassPackage subPackage : this.subPackages.values()) {
            subPackage.traverse(matcher.match(subPackage.getShortName()), visitor);
        }
    }
}

