/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.resolve.ClassCollector;
import de.spricom.dessert.resolve.ClassPackage;
import de.spricom.dessert.resolve.ClassRoot;
import de.spricom.dessert.resolve.DirectoryClassEntry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

final class DirectoryRoot
extends ClassRoot {
    public DirectoryRoot(File dir) {
        super(dir);
    }

    @Override
    protected void scan(ClassCollector collector) {
        this.scan(collector, this, this.getRootFile(), "");
    }

    private void scan(ClassCollector collector, ClassPackage pckg, File dir, String prefix) {
        collector.addPackage(pckg);
        for (File file : dir.listFiles()) {
            String filename = file.getName();
            if (file.isDirectory()) {
                String packageName = prefix + filename;
                ClassPackage subPackage = new ClassPackage(pckg, packageName);
                this.scan(collector, subPackage, file, packageName + ".");
                continue;
            }
            if (!filename.endsWith(".class")) continue;
            DirectoryClassEntry classEntry = new DirectoryClassEntry(pckg, file);
            pckg.addClass(classEntry);
            collector.addClass(classEntry);
        }
    }

    @Override
    public URL getResource(String name) {
        File file = new File(this.getRootFile(), name);
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Cannot get URL for " + file.getPath() + ": " + ex, ex);
        }
    }
}

