/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.resolve.ClassCollector;
import de.spricom.dessert.resolve.ClassPackage;
import de.spricom.dessert.resolve.ClassRoot;
import de.spricom.dessert.resolve.JarClassEntry;
import de.spricom.dessert.resolve.VersionsHelper;
import de.spricom.dessert.util.Assertions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

final class JarRoot
extends ClassRoot {
    private JarFile jarFileArchive;

    public JarRoot(File jarFile) {
        super(jarFile);
    }

    @Override
    protected void scan(ClassCollector collector) throws IOException {
        HashMap<String, ClassPackage> packages = new HashMap<String, ClassPackage>();
        packages.put("", this);
        collector.addPackage(this);
        JarFile jarFile = this.getJarFileArchive();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            this.addClass(collector, packages, jarFile, entry);
        }
    }

    private JarFile getJarFileArchive() throws IOException {
        if (this.jarFileArchive == null) {
            this.jarFileArchive = new JarFile(this.getRootFile());
        }
        return this.jarFileArchive;
    }

    private void addClass(ClassCollector collector, Map<String, ClassPackage> packages, JarFile jarFile, JarEntry entry) {
        ClassPackage pckg = this.ensurePackage(collector, packages, this.packageName(entry));
        JarClassEntry ce = new JarClassEntry(pckg, jarFile, entry);
        pckg.addClass(ce);
        collector.addClass(ce);
    }

    private String packageName(JarEntry entry) {
        String path = VersionsHelper.removeVersionPrefix(entry.getName());
        return this.packageName(path, '/').replace('/', '.');
    }

    private ClassPackage ensurePackage(ClassCollector collector, Map<String, ClassPackage> packages, String packageName) {
        ClassPackage pckg = packages.get(packageName);
        if (pckg != null) {
            return pckg;
        }
        ClassPackage parent = this.ensurePackage(collector, packages, this.parentPackageName(packageName));
        pckg = new ClassPackage(parent, packageName);
        collector.addPackage(pckg);
        packages.put(packageName, pckg);
        return pckg;
    }

    private String parentPackageName(String packageName) {
        return this.packageName(packageName, '.');
    }

    private String packageName(String name, char separator) {
        int index = name.lastIndexOf(separator);
        if (index == -1) {
            return "";
        }
        String packageName = name.substring(0, index);
        return packageName;
    }

    @Override
    public URL getResource(String name) {
        JarEntry jarEntry = this.getJarEntry(name);
        if (jarEntry == null) {
            return null;
        }
        try {
            return new URL("jar:" + this.getRootFile().toURI().toURL() + "!/" + jarEntry.getName());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Unable to convert " + this.getRootFile().toURI() + " to an URL: " + ex, ex);
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        JarEntry jarEntry = this.getJarEntry(name);
        if (jarEntry == null) {
            return null;
        }
        try {
            return this.jarFileArchive.getInputStream(jarEntry);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to read " + jarEntry.getName() + " from jar-archive " + this.getRootFile().getPath() + ": " + ex, ex);
        }
    }

    public JarEntry getJarEntry(String name) {
        Assertions.notNull(name, "name");
        try {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            JarEntry jarEntry = this.getJarFileArchive().getJarEntry(name);
            return jarEntry;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read jar-archive " + this.getRootFile().getPath() + ": " + ex, ex);
        }
    }

    @Override
    public Manifest getManifest() throws IOException {
        JarFile jarFile = this.getJarFileArchive();
        Manifest manifest = jarFile.getManifest();
        return manifest;
    }
}

