/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class ReflectiveJrtFileSystem {
    private final Class<?> fileSystems = Class.forName("java.nio.file.FileSystems");
    private final Method newFileSystem = this.fileSystems.getMethod("newFileSystem", URI.class, Map.class);
    private final Class<?> fileSystem = Class.forName("java.nio.file.FileSystem");
    private final Method getPath = this.fileSystem.getMethod("getPath", String.class, String[].class);
    private final Class<?> path = Class.forName("java.nio.file.Path");
    private final Method toUri = this.path.getMethod("toUri", new Class[0]);
    private final Method getFileName = this.path.getMethod("getFileName", new Class[0]);
    private final Class<?> files = Class.forName("java.nio.file.Files");
    private final Method newDirectoryStream = this.files.getMethod("newDirectoryStream", this.path);
    private final Method isDirectory;
    private final Class<?> linkOption = Class.forName("java.nio.file.LinkOption");
    private final Object emptyLinkOptionsArray = Array.newInstance(this.linkOption, 0);
    private final Object jrtFileSystem;

    ReflectiveJrtFileSystem() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.isDirectory = this.files.getMethod("isDirectory", this.path, this.emptyLinkOptionsArray.getClass());
        this.jrtFileSystem = this.newFileSystem.invoke(null, URI.create("jrt:/"), Collections.emptyMap());
    }

    Object getModulePath(String moduleName) throws InvocationTargetException, IllegalAccessException {
        return this.getPath.invoke(this.jrtFileSystem, "/modules/" + moduleName, new String[0]);
    }

    boolean isDirectory(Object path) throws InvocationTargetException, IllegalAccessException {
        return (Boolean)this.isDirectory.invoke(null, path, this.emptyLinkOptionsArray);
    }

    Iterable<Object> newDirectoryStream(Object path) throws InvocationTargetException, IllegalAccessException {
        return (Iterable)this.newDirectoryStream.invoke(null, path);
    }

    URI toUri(Object path) throws InvocationTargetException, IllegalAccessException, URISyntaxException {
        URI uri = (URI)this.toUri.invoke(path, new Object[0]);
        if (uri.toASCIIString().startsWith("jrt:/modules/")) {
            uri = new URI(uri.toASCIIString().replace("jrt:/modules/", "jrt:/"));
        }
        return uri;
    }

    String getFileName(Object path) throws InvocationTargetException, IllegalAccessException {
        return this.getFileName.invoke(path, new Object[0]).toString();
    }

    List<String> listModules() throws InvocationTargetException, IllegalAccessException, URISyntaxException {
        ArrayList<String> moduleNames = new ArrayList<String>(64);
        Object modulesRoot = this.getPath.invoke(this.jrtFileSystem, "/modules", new String[0]);
        for (Object module : this.newDirectoryStream(modulesRoot)) {
            String path = this.toUri(module).getPath();
            moduleNames.add(path.substring(path.lastIndexOf(47) + 1));
        }
        return moduleNames;
    }
}

