/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.resolve;

import de.spricom.dessert.resolve.ClassPackage;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionsHelper {
    private static final Logger log = Logger.getLogger(ClassPackage.class.getName());
    private static final Pattern VERSIONED_ENTRY_PREFIX = Pattern.compile("META-INF/versions/(\\d+)/");

    private VersionsHelper() {
    }

    public static String removeVersionPrefix(String name) {
        Matcher matcher = VERSIONED_ENTRY_PREFIX.matcher(name);
        if (matcher.lookingAt()) {
            return name.substring(matcher.end());
        }
        return name;
    }

    public static Integer getVersion(String name) {
        Matcher matcher = VERSIONED_ENTRY_PREFIX.matcher(name);
        if (matcher.lookingAt()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException ex) {
                log.warning("Invalid version " + matcher.group(1) + " within " + name);
            }
        }
        return null;
    }
}

