/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.matching.NamePattern;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.ConcreteSlice;
import de.spricom.dessert.slicing.NamedSlice;
import de.spricom.dessert.slicing.PackageSlice;
import de.spricom.dessert.slicing.PartitionSlice;
import de.spricom.dessert.slicing.PartitionSliceFactory;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.slicing.SlicePartitioner;
import de.spricom.dessert.slicing.Slices;
import de.spricom.dessert.slicing.UnionSlice;
import de.spricom.dessert.util.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class AbstractSlice
implements Slice {
    AbstractSlice() {
    }

    @Override
    public Slice plus(Iterable<? extends Slice> slices) {
        LinkedList<Slice> list = new LinkedList<Slice>();
        list.add(this);
        for (Slice slice : slices) {
            list.add(slice);
        }
        if (list.size() == 1) {
            return (Slice)list.get(0);
        }
        return new UnionSlice(list);
    }

    @Override
    public Slice plus(Slice ... slices) {
        if (slices.length == 0) {
            return this;
        }
        ArrayList<Slice> list = new ArrayList<Slice>(slices.length + 1);
        list.add(this);
        list.addAll(Arrays.asList(slices));
        return new UnionSlice(list);
    }

    @Override
    public Slice minus(Iterable<? extends Slice> slices) {
        final Slice union = Slices.of(slices);
        Predicate<Clazz> excluded = new Predicate<Clazz>(){

            @Override
            public boolean test(Clazz clazz) {
                return !union.contains(clazz);
            }
        };
        return this.slice(excluded);
    }

    @Override
    public Slice minus(Slice ... slices) {
        return this.minus(Arrays.asList(slices));
    }

    @Override
    public Slice minus(String pattern) {
        return this.minus(this.slice(pattern));
    }

    @Override
    public Slice minus(Predicate<Clazz> predicate) {
        return this.minus(this.slice(predicate));
    }

    @Override
    public Slice slice(Iterable<? extends Slice> slices) {
        LinkedList<Slice> list = new LinkedList<Slice>();
        for (Slice slice : slices) {
            list.add(slice);
        }
        if (list.isEmpty()) {
            return this;
        }
        final Slice union = list.size() == 1 ? (Slice)list.get(0) : new UnionSlice(list);
        Predicate<Clazz> predicate = new Predicate<Clazz>(){

            @Override
            public boolean test(Clazz clazz) {
                return union.contains(clazz);
            }
        };
        return this.slice(predicate);
    }

    @Override
    public Slice slice(Slice ... slices) {
        return this.slice(Arrays.asList(slices));
    }

    @Override
    public Slice slice(String pattern) {
        final NamePattern namePattern = NamePattern.of(pattern);
        return this.slice(new Predicate<Clazz>(){

            @Override
            public boolean test(Clazz clazz) {
                return namePattern.matches(clazz.getName());
            }
        });
    }

    @Override
    public Slice dependencyClosure(Slice within) {
        int count;
        Slice result = this.slice(within);
        do {
            count = result.getClazzes().size();
        } while ((result = result.plus(result.getDependencies()).slice(within)).getClazzes().size() != count);
        return result;
    }

    @Override
    public ConcreteSlice getDependencies() {
        HashSet<Clazz> dependencies = new HashSet<Clazz>();
        for (Clazz clazz : this.getClazzes()) {
            dependencies.addAll(clazz.getDependencies().getClazzes());
        }
        return new ConcreteSlice(dependencies);
    }

    @Override
    public boolean uses(Slice other) {
        if (this == other) {
            return false;
        }
        for (Clazz clazz : this.getClazzes()) {
            for (Clazz dependency : clazz.getDependencies().getClazzes()) {
                for (Clazz alternative : dependency.getAlternatives()) {
                    if (!other.contains(alternative)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Slice named(String name) {
        return new NamedSlice(this, name);
    }

    @Override
    public SortedMap<String, PackageSlice> partitionByPackage() {
        return this.partitionBy(PackageSlice.partitioner(), PackageSlice.factory());
    }

    @Override
    public SortedMap<String, PartitionSlice> partitionBy(SlicePartitioner partitioner) {
        return this.partitionBy(partitioner, new PartitionSliceFactory<PartitionSlice>(){

            @Override
            public PartitionSlice createPartSlice(String partKey, Set<Clazz> entries, Map<String, PartitionSlice> slices) {
                return new PartitionSlice(partKey, entries);
            }
        });
    }

    @Override
    public <S extends PartitionSlice> SortedMap<String, S> partitionBy(SlicePartitioner partitioner, PartitionSliceFactory<S> partitionSliceFactory) {
        HashMap<String, HashSet<Clazz>> split = new HashMap<String, HashSet<Clazz>>();
        for (Clazz clazz : this.getClazzes()) {
            String key = partitioner.partKey(clazz);
            if (key == null) continue;
            HashSet<Clazz> matches = (HashSet<Clazz>)split.get(key);
            if (matches == null) {
                matches = new HashSet<Clazz>();
                split.put(key, matches);
            }
            matches.add(clazz);
        }
        TreeMap slices = new TreeMap();
        for (Map.Entry matches : split.entrySet()) {
            slices.put(matches.getKey(), partitionSliceFactory.createPartSlice((String)matches.getKey(), (Set)matches.getValue(), slices));
        }
        return slices;
    }
}

