/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.slicing.AbstractSlice;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.Concrete;
import de.spricom.dessert.util.Predicate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ConcreteSlice
extends AbstractSlice
implements Concrete {
    public static final ConcreteSlice EMPTY_SLICE = new ConcreteSlice(Collections.<Clazz>emptySet());
    private final Set<Clazz> entries;

    protected ConcreteSlice(Set<Clazz> entries) {
        this.entries = entries;
    }

    @Override
    public ConcreteSlice slice(Predicate<Clazz> predicate) {
        HashSet<Clazz> filtered = new HashSet<Clazz>(this.entries.size());
        for (Clazz entry : this.entries) {
            if (!predicate.test(entry)) continue;
            filtered.add(entry);
        }
        if (filtered.isEmpty()) {
            return EMPTY_SLICE;
        }
        return new ConcreteSlice(filtered);
    }

    @Override
    public boolean contains(Clazz entry) {
        return this.entries.contains(entry);
    }

    @Override
    public Set<Clazz> getClazzes() {
        return this.entries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("slice of [");
        Iterator<Clazz> iter = this.entries.iterator();
        boolean first = true;
        while (iter.hasNext() && sb.length() < 60) {
            Clazz entry = iter.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getName());
        }
        if (iter.hasNext()) {
            sb.append(" ...");
        }
        sb.append("]");
        return sb.toString();
    }
}

