/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.matching.NamePattern;
import de.spricom.dessert.resolve.ResolveException;
import de.spricom.dessert.slicing.AbstractSlice;
import de.spricom.dessert.slicing.Clazz;
import de.spricom.dessert.slicing.Slice;
import de.spricom.dessert.util.Predicate;
import de.spricom.dessert.util.Predicates;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

final class DerivedSlice
extends AbstractSlice {
    private final Set<NamePattern> namePatterns;
    private final Predicate<Clazz> predicate;
    private final Set<Clazz> cache = new TreeSet<Clazz>();

    private DerivedSlice(Set<NamePattern> namePatterns, Predicate<Clazz> predicate) {
        this.namePatterns = namePatterns;
        this.predicate = predicate;
    }

    DerivedSlice(NamePattern namePattern) {
        this(Collections.singleton(namePattern), Predicates.any());
    }

    DerivedSlice(Predicate<Clazz> predicate) {
        this(Collections.emptySet(), predicate);
    }

    @Override
    public Slice slice(final Predicate<Clazz> predicate) {
        return new DerivedSlice(new Predicate<Clazz>(){

            @Override
            public boolean test(Clazz clazz) {
                return DerivedSlice.this.contains(clazz) && predicate.test(clazz);
            }
        });
    }

    @Override
    public Slice slice(String pattern) {
        TreeSet<NamePattern> patterns = new TreeSet<NamePattern>(this.namePatterns);
        patterns.add(NamePattern.of(pattern));
        return new DerivedSlice(patterns, this.predicate);
    }

    @Override
    public boolean contains(Clazz entry) {
        if (this.cache.contains(entry)) {
            return true;
        }
        for (NamePattern namePattern : this.namePatterns) {
            if (namePattern.matches(entry.getName())) continue;
            return false;
        }
        boolean member = this.predicate.test(entry);
        if (member) {
            this.cache.add(entry);
        }
        return member;
    }

    @Override
    public Set<Clazz> getClazzes() {
        throw new ResolveException("Cannot get classes for " + this);
    }

    public String toString() {
        if (this.namePatterns.isEmpty()) {
            return "slice from " + this.predicate;
        }
        if (this.namePatterns.size() == 1) {
            return "slice " + this.namePatterns.iterator().next();
        }
        return "slice " + this.namePatterns;
    }
}

