/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.slicing;

import de.spricom.dessert.matching.NamePattern;
import de.spricom.dessert.resolve.ClassEntry;
import de.spricom.dessert.resolve.ClassVisitor;
import de.spricom.dessert.resolve.ResolveException;
import de.spricom.dessert.resolve.TraversalRoot;
import de.spricom.dessert.slicing.AbstractClazzResolver;
import de.spricom.dessert.slicing.Classpath;
import de.spricom.dessert.slicing.Clazz;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

final class NamePatternClazzResolver
extends AbstractClazzResolver
implements ClassVisitor {
    private final NamePattern pattern;
    private final TraversalRoot root;
    private final Set<NamePattern> additionalPatterns;

    NamePatternClazzResolver(Classpath cp, NamePattern pattern, TraversalRoot root) {
        this(cp, pattern, root, Collections.emptySet());
    }

    private NamePatternClazzResolver(Classpath cp, NamePattern pattern, TraversalRoot root, Set<NamePattern> additionalPatterns) {
        super(cp);
        this.pattern = pattern;
        this.root = root;
        this.additionalPatterns = additionalPatterns;
    }

    @Override
    protected void resolve() {
        this.root.traverse(this.pattern, this);
    }

    @Override
    public void visit(ClassEntry ce) {
        for (NamePattern additionalPattern : this.additionalPatterns) {
            if (additionalPattern.matches(ce.getClassname())) continue;
            return;
        }
        this.add(ce);
    }

    @Override
    public Set<Clazz> getClazzes() {
        Set<Clazz> clazzes = super.getClazzes();
        if (clazzes.isEmpty() && this.pattern.isAny()) {
            throw new ResolveException("No classes found in " + this.root);
        }
        return clazzes;
    }

    public NamePatternClazzResolver filtered(NamePattern additionalPattern) {
        TreeSet<NamePattern> patterns = new TreeSet<NamePattern>(this.additionalPatterns);
        if (additionalPattern.isMoreConcreteThan(this.pattern)) {
            patterns.add(this.pattern);
            return new NamePatternClazzResolver(this.getClasspath(), additionalPattern, this.root, patterns);
        }
        patterns.add(additionalPattern);
        return new NamePatternClazzResolver(this.getClasspath(), this.pattern, this.root, patterns);
    }

    public NamePatternClazzResolver replace(NamePattern replacementPattern) {
        return new NamePatternClazzResolver(this.getClasspath(), replacementPattern, this.root);
    }
}

