/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.util;

import de.spricom.dessert.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CombinationUtils {
    public static <T> List<Pair<T>> combinationsAsList(List<T> list) {
        return CombinationUtils.asList(CombinationUtils.combinations(list), CombinationUtils.combinations(list.size()));
    }

    public static <T> List<Pair<T>> combinationsSortedAsList(List<T> list) {
        return CombinationUtils.asList(CombinationUtils.combinationsSorted(list), CombinationUtils.combinationsSorted(list.size()));
    }

    private static <T> List<Pair<T>> asList(Iterable<Pair<T>> iter, int capacity) {
        ArrayList<Pair<T>> results = new ArrayList<Pair<T>>(capacity);
        for (Pair<T> tPair : iter) {
            results.add(tPair);
        }
        return results;
    }

    public static <T> Iterable<Pair<T>> combinations(final List<T> list) {
        return new Iterable<Pair<T>>(){

            @Override
            public Iterator<Pair<T>> iterator() {
                return CombinationUtils.both(CombinationUtils.pairs(list));
            }
        };
    }

    public static <T> Iterable<Pair<T>> combinationsSorted(final List<T> list) {
        return new Iterable<Pair<T>>(){

            @Override
            public Iterator<Pair<T>> iterator() {
                return CombinationUtils.pairs(list);
            }
        };
    }

    public static List<Integer> indexes(int size) {
        Integer[] indexes = new Integer[size];
        for (int i = 0; i < size; ++i) {
            indexes[i] = i;
        }
        return Arrays.asList(indexes);
    }

    private static <T> Iterator<Pair<T>> both(final Iterator<Pair<T>> pairs) {
        return new PermutationIterator<T>(){
            private Pair<T> current;

            @Override
            public boolean hasNext() {
                return this.current != null || pairs.hasNext();
            }

            @Override
            public Pair<T> next() {
                if (this.current == null) {
                    this.current = (Pair)pairs.next();
                    return this.current;
                }
                Pair other = new Pair(this.current.getRight(), this.current.getLeft());
                this.current = null;
                return other;
            }
        };
    }

    private static <T> Iterator<Pair<T>> pairs(final List<T> list) {
        final int sz = list.size();
        if (sz < 2) {
            throw new IllegalArgumentException("A list must contain at least 2 elements to create a permutation.");
        }
        if (sz == 2) {
            return Collections.singleton(new Pair<T>(list.get(0), list.get(1))).iterator();
        }
        return new PermutationIterator<T>(){
            private final T first;
            private int index;
            private Iterator<Pair<T>> rest;
            {
                this.first = list.get(0);
                this.index = 1;
            }

            @Override
            public boolean hasNext() {
                return this.index < sz || this.rest().hasNext();
            }

            @Override
            public Pair<T> next() {
                if (this.index < sz) {
                    Pair result = new Pair(this.first, list.get(this.index));
                    ++this.index;
                    return result;
                }
                return this.rest().next();
            }

            private Iterator<Pair<T>> rest() {
                if (this.rest == null) {
                    this.rest = CombinationUtils.pairs(list.subList(1, sz));
                }
                return this.rest;
            }
        };
    }

    public static int combinations(int n) {
        return CombinationUtils.combinationsSorted(n) * 2;
    }

    public static int combinationsSorted(int n) {
        return CombinationUtils.binominal(n, 2);
    }

    public static int binominal(int n, int k) {
        if (k * 2 > n) {
            k = n - k;
        }
        int result = 1;
        for (int i = 1; i <= k; ++i) {
            result = result * (n + 1 - i) / i;
        }
        return result;
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Factorial for negative numbers is not defined");
        }
        if (n <= 1) {
            return 1;
        }
        long result = 1L;
        for (int i = 2; i <= n; ++i) {
            if ((result *= (long)i) <= Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Factorial of " + n + " does not fit into an integer.");
        }
        return (int)result;
    }

    static abstract class PermutationIterator<T>
    implements Iterator<Pair<T>> {
        PermutationIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements from permutation.");
        }
    }
}

