/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Dag<T> {
    private final Map<T, Node<T>> nodes = new HashMap<T, Node<T>>();
    private LinkedList<Node<T>> sorted;
    private LinkedList<Node<T>> cycle;

    public void addEdge(T from, T to) {
        this.sorted = null;
        this.getNode(from).edges.add(this.getNode(to));
    }

    private Node<T> getNode(T value) {
        Node<T> n = this.nodes.get(value);
        if (n == null) {
            n = new Node<T>(value);
            this.nodes.put(value, n);
        }
        return n;
    }

    public boolean isCycleFree() {
        if (this.sorted == null) {
            this.sort();
        }
        return this.cycle == null;
    }

    public List<T> cycle() {
        return this.values(this.cycle);
    }

    private List<T> values(List<Node<T>> nodes) {
        ArrayList list = new ArrayList(nodes.size());
        for (Node<T> node : nodes) {
            list.add(node.value);
        }
        return list;
    }

    private void sort() {
        this.sorted = new LinkedList();
        for (Node<T> n : this.nodes.values()) {
            if (!this.visit(n)) continue;
            return;
        }
    }

    private boolean visit(Node<T> n) {
        if (n.mark == Mark.PERMANENT) {
            return false;
        }
        if (n.mark == Mark.TEMPORARY) {
            this.cycle = new LinkedList();
            this.cycle.add(n);
            return true;
        }
        n.mark = Mark.TEMPORARY;
        for (Node m : n.edges) {
            if (!this.visit(m)) continue;
            this.cycle.addFirst(n);
            return true;
        }
        n.mark = Mark.PERMANENT;
        this.sorted.addFirst(n);
        return false;
    }

    static final class Node<T> {
        final T value;
        final Set<Node<T>> edges = new HashSet<Node<T>>();
        Mark mark = Mark.NONE;

        public Node(T value) {
            assert (value != null) : "value == null";
            this.value = value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.value.equals(other.value);
        }
    }

    static enum Mark {
        NONE,
        TEMPORARY,
        PERMANENT;

    }
}

