/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.jpushover.apis;

import de.svenkubiak.jpushover.apis.API;
import de.svenkubiak.jpushover.enums.Param;
import de.svenkubiak.jpushover.enums.Url;
import de.svenkubiak.jpushover.exceptions.JPushoverException;
import de.svenkubiak.jpushover.http.PushoverRequest;
import de.svenkubiak.jpushover.http.PushoverResponse;
import de.svenkubiak.jpushover.services.AsyncExecutor;
import de.svenkubiak.jpushover.services.AsyncService;
import de.svenkubiak.jpushover.utils.Validate;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Future;

public class Glance
implements API {
    private NavigableMap<String, String> body = new TreeMap<String, String>();
    private String proxyHost;
    private int proxyPort;

    public Glance withToken(String string) {
        Objects.requireNonNull(string, "token can not be null");
        this.body.put(Param.TOKEN.toString(), string);
        return this;
    }

    public Glance withUser(String string) {
        Objects.requireNonNull(string, "user can not be null");
        this.body.put(Param.USER.toString(), string);
        return this;
    }

    public Glance withDevice(String string) {
        Objects.requireNonNull(string, "device can not be null");
        this.body.put(Param.DEVICE.toString(), string);
        return this;
    }

    public Glance withTitle(String string) {
        Objects.requireNonNull(string, "title can not be null");
        Validate.checkArgument(string.length() <= 100, "Title must not exceed a length of 100 characters");
        this.body.put(Param.TITLE.toString(), string);
        return this;
    }

    public Glance withText(String string) {
        Objects.requireNonNull(string, "text can not be null");
        Validate.checkArgument(string.length() <= 100, "Text must not exceed a length of 100 characters");
        this.body.put(Param.TEXT.toString(), string);
        return this;
    }

    public Glance withSubtext(String string) {
        Objects.requireNonNull(string, "subtext can not be null");
        Validate.checkArgument(string.length() <= 100, "Subtext must not exceed a length of 100 characters");
        this.body.put(Param.SUBTEXT.toString(), string);
        return this;
    }

    public Glance withCount(int n) {
        this.body.put(Param.COUNT.toString(), String.valueOf(n));
        return this;
    }

    public Glance withPercent(int n) {
        this.body.put(Param.PERCENT.toString(), String.valueOf(n));
        return this;
    }

    public Glance withProxy(String string, int n) {
        Objects.requireNonNull(string, "proxyHost can not be null");
        Validate.checkArgument(n > 0, "proxyPort must be greater than null");
        this.proxyHost = string;
        this.proxyPort = n;
        return this;
    }

    @Override
    public PushoverResponse push() throws JPushoverException {
        Objects.requireNonNull((String)this.body.get(Param.TOKEN.toString()), "Token is required for a glance");
        Objects.requireNonNull((String)this.body.get(Param.USER.toString()), "User is required for a glance");
        return new PushoverRequest().push(Url.GLANCES.toString(), this.body, this.proxyHost, this.proxyPort);
    }

    public Future<PushoverResponse> pushAsync() {
        return AsyncService.getInstance().execute(new AsyncExecutor<PushoverResponse>(this));
    }

    public String getValue(String string) {
        Objects.requireNonNull(string, "param can not be null");
        return (String)this.body.get(string);
    }
}

