/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.jpushover.apis;

import de.svenkubiak.jpushover.apis.API;
import de.svenkubiak.jpushover.enums.Param;
import de.svenkubiak.jpushover.enums.Priority;
import de.svenkubiak.jpushover.enums.Sound;
import de.svenkubiak.jpushover.enums.Url;
import de.svenkubiak.jpushover.exceptions.JPushoverException;
import de.svenkubiak.jpushover.http.PushoverRequest;
import de.svenkubiak.jpushover.http.PushoverResponse;
import de.svenkubiak.jpushover.services.AsyncExecutor;
import de.svenkubiak.jpushover.services.AsyncService;
import de.svenkubiak.jpushover.utils.Validate;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class Message
implements API {
    private NavigableMap<String, String> body = new TreeMap<String, String>();
    private String proxyHost;
    private int proxyPort;

    public Message() {
        this.withPriority(Priority.NORMAL);
        this.withSound(Sound.PUSHOVER);
    }

    public Message withToken(String string) {
        this.body.put(Param.TOKEN.toString(), string);
        return this;
    }

    public Message withUser(String string) {
        this.body.put(Param.USER.toString(), string);
        return this;
    }

    public Message withRetry(int n) {
        this.body.put(Param.RETRY.toString(), String.valueOf(n));
        return this;
    }

    public Message withExpire(int n) {
        this.body.put(Param.EXPIRE.toString(), String.valueOf(n));
        return this;
    }

    public Message withMessage(String string) {
        this.body.put(Param.MESSAGE.toString(), string);
        return this;
    }

    public Message withDevice(String string) {
        this.body.put(Param.DEVICE.toString(), string);
        return this;
    }

    public Message withTitle(String string) {
        this.body.put(Param.TITLE.toString(), string);
        return this;
    }

    public Message withUrl(String string) {
        this.body.put(Param.URL.toString(), string);
        this.body.put(Param.URL_TITLE.toString(), string);
        return this;
    }

    public Message enableMonospace() {
        this.body.put(Param.MONOSPACE.toString(), "1");
        this.body.put(Param.HTML.toString(), "0");
        return this;
    }

    public Message enableHtml() {
        this.body.put(Param.MONOSPACE.toString(), "0");
        this.body.put(Param.HTML.toString(), "1");
        return this;
    }

    public Message withUrlTitle(String string) {
        this.body.put(Param.URL_TITLE.toString(), string);
        return this;
    }

    public Message withTimestamp(int n) {
        this.body.put(Param.TIMESTAMP.toString(), String.valueOf(n));
        return this;
    }

    public Message withPriority(Priority priority) {
        this.body.put(Param.PRIORITY.toString(), priority.toString());
        return this;
    }

    public Message withSound(Sound sound) {
        this.body.put(Param.SOUND.toString(), sound.toString());
        return this;
    }

    public Message withCallback(String string) {
        this.body.put(Param.CALLBACK.toString(), string);
        return this;
    }

    public Message withTTL(int n) {
        Validate.checkArgument(n > 0, "TTL must be a positive value");
        this.body.put(Param.TTL.toString(), String.valueOf(n));
        return this;
    }

    public Message withProxy(String string, int n) {
        Objects.requireNonNull(string, "proxyHost can not be null");
        Validate.checkArgument(n > 0, "proxyPort must be greater than null");
        this.proxyHost = string;
        this.proxyPort = n;
        return this;
    }

    public boolean validate() throws JPushoverException {
        String string;
        Objects.requireNonNull((String)this.body.get(Param.TOKEN.toString()), "Token is required for validation");
        Objects.requireNonNull((String)this.body.get(Param.USER.toString()), "User is required for validation");
        PushoverResponse pushoverResponse = new PushoverRequest().push(Url.VALIDATE.toString(), this.body, this.proxyHost, this.proxyPort);
        boolean bl = false;
        if (pushoverResponse.getHttpStatus() == 200 && (string = pushoverResponse.getResponse()) != null && string.contains("\"status\":1")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public PushoverResponse push() throws JPushoverException {
        Objects.requireNonNull((String)this.body.get(Param.TOKEN.toString()), "Token is required for a message");
        Objects.requireNonNull((String)this.body.get(Param.USER.toString()), "User is required for a message");
        Objects.requireNonNull((String)this.body.get(Param.MESSAGE.toString()), "Message is required for a message");
        Validate.checkArgument(((String)this.body.get(Param.MESSAGE.toString())).length() <= 1024, "Message can not exceed more than 1024 characters");
        if (Priority.EMERGENCY.toString().equals(this.body.get(Param.PRIORITY.toString()))) {
            this.body.putIfAbsent(Param.RETRY.toString(), "60");
            this.body.putIfAbsent(Param.EXPIRE.toString(), "3600");
        }
        if (this.body.get(Param.TITLE.toString()) != null) {
            Validate.checkArgument(((String)this.body.get(Param.TITLE.toString())).length() <= 250, "Title can not exceed more than 250 characters");
        }
        if (this.body.get(Param.URL.toString()) != null) {
            Validate.checkArgument(((String)this.body.get(Param.URL.toString())).length() <= 512, "URL can not exceed more than 512 characters");
        }
        if (this.body.get(Param.URL_TITLE.toString()) != null) {
            Validate.checkArgument(((String)this.body.get(Param.URL_TITLE.toString())).length() <= 100, "URL Title can not exceed more than 100 characters");
        }
        return new PushoverRequest().push(Url.MESSAGES.toString(), this.body, this.proxyHost, this.proxyPort);
    }

    public Future<PushoverResponse> pushAsync() throws InterruptedException, ExecutionException {
        return AsyncService.getInstance().execute(new AsyncExecutor<PushoverResponse>(this));
    }

    public String getValue(String string) {
        Objects.requireNonNull(string, "param can not be null");
        return (String)this.body.get(string);
    }
}

