/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.jpushover.apis;

import de.svenkubiak.jpushover.enums.Url;
import de.svenkubiak.jpushover.exceptions.JPushoverException;
import de.svenkubiak.jpushover.http.PushoverResponse;
import de.svenkubiak.jpushover.listener.MessageListener;
import de.svenkubiak.jpushover.listener.WebSocketListener;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.Objects;

public class OpenClient {
    private HttpClient client = HttpClient.newHttpClient();
    private static final Duration TIMEOUT = Duration.ofSeconds(5L);
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    private WebSocket webSocket;

    public PushoverResponse login(String string, String string2, String string3) throws JPushoverException {
        Objects.requireNonNull(string, "email can not be null");
        Objects.requireNonNull(string2, "password can not be null");
        StringBuilder stringBuilder = new StringBuilder().append("email").append('=').append(string).append('&').append("password").append('=').append(string2);
        if (string3 != null) {
            stringBuilder.append('&').append("twofa").append('=').append(string3);
        }
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(Url.LOGIN.toString())).timeout(TIMEOUT).POST(HttpRequest.BodyPublishers.ofString(stringBuilder.toString())).build();
        PushoverResponse pushoverResponse = PushoverResponse.create().isSuccessful(false);
        try {
            HttpResponse<String> httpResponse = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            pushoverResponse.httpStatus(httpResponse.statusCode()).response(httpResponse.body()).isSuccessful(httpResponse.statusCode() == 200);
        }
        catch (IOException | InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new JPushoverException("Pushover Login failed", exception);
        }
        return pushoverResponse;
    }

    public PushoverResponse login(String string, String string2) throws JPushoverException {
        return this.login(string, string2, null);
    }

    public String messages(String string, String string2) throws JPushoverException {
        Objects.requireNonNull(string, "secret can not be null");
        Objects.requireNonNull(string2, "deviceId can not be null");
        StringBuilder stringBuilder = new StringBuilder().append("?secret").append("=").append(string).append("&").append("deviceId").append("=").append(string2);
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(Url.MESSAGES.toString() + stringBuilder.toString())).timeout(TIMEOUT).header(CONTENT_TYPE, APPLICATION_JSON).build();
        String string3 = null;
        try {
            HttpResponse<String> httpResponse = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            string3 = httpResponse.body();
        }
        catch (IOException | InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new JPushoverException("Failed to get messages", exception);
        }
        return string3;
    }

    public PushoverResponse deleteMessages(String string, String string2, String string3) throws JPushoverException {
        Objects.requireNonNull(string2, "secret can not be null");
        Objects.requireNonNull(string, "deviceId can not be null");
        Objects.requireNonNull(string3, "messageId can not be null");
        StringBuilder stringBuilder = new StringBuilder().append("secret").append("=").append(string).append("&").append("message").append("=").append(string3);
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(Url.DELETE.toString().replace("###DEVICE_ID###", string2))).timeout(TIMEOUT).header(CONTENT_TYPE, APPLICATION_JSON).POST(HttpRequest.BodyPublishers.ofString(stringBuilder.toString())).build();
        PushoverResponse pushoverResponse = PushoverResponse.create().isSuccessful(false);
        try {
            HttpResponse<String> httpResponse = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            pushoverResponse.httpStatus(httpResponse.statusCode()).response(httpResponse.body()).isSuccessful(httpResponse.statusCode() == 200);
        }
        catch (IOException | InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new JPushoverException("Failed to delete messages", exception);
        }
        return pushoverResponse;
    }

    public boolean open(String string, String string2, MessageListener messageListener) {
        Objects.requireNonNull(string, "secret can not be null");
        Objects.requireNonNull(string2, "deviceId name can not be null");
        Objects.requireNonNull(messageListener, "messageListener can not be null");
        this.webSocket = this.client.newWebSocketBuilder().buildAsync(URI.create(Url.WEBSOCKET.toString()), new WebSocketListener(messageListener)).join();
        StringBuilder stringBuilder = new StringBuilder().append("login").append(":").append(string2).append(":").append(string).append("\n");
        this.webSocket.sendText(stringBuilder.toString(), true);
        return !this.webSocket.isInputClosed();
    }

    public PushoverResponse registerDevice(String string, String string2) throws JPushoverException {
        Objects.requireNonNull(string, "secret can not be null");
        Objects.requireNonNull(string2, "device name can not be null");
        StringBuilder stringBuilder = new StringBuilder().append("secret").append("=").append(string).append("&").append("name").append("=").append(string2).append("&os=O");
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(Url.DEVICE.toString())).POST(HttpRequest.BodyPublishers.ofString(stringBuilder.toString())).build();
        PushoverResponse pushoverResponse = PushoverResponse.create().isSuccessful(false);
        try {
            HttpResponse<String> httpResponse = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            pushoverResponse.httpStatus(httpResponse.statusCode()).response(httpResponse.body()).isSuccessful(true);
        }
        catch (IOException | InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new JPushoverException("Failed to register new device", exception);
        }
        return pushoverResponse;
    }

    public boolean close() {
        boolean bl = false;
        if (this.webSocket != null) {
            this.webSocket.sendClose(1000, "ok");
            bl = this.webSocket.isInputClosed() && this.webSocket.isOutputClosed();
            this.webSocket = null;
        }
        return bl;
    }
}

