/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.jpushover.http;

import de.svenkubiak.jpushover.exceptions.JPushoverException;
import de.svenkubiak.jpushover.http.PushoverResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.OptionalLong;

public class PushoverRequest {
    public PushoverResponse push(String string, NavigableMap<String, String> navigableMap, String string2, int n) throws JPushoverException {
        Objects.requireNonNull(string, "API URL can not be null");
        Objects.requireNonNull(navigableMap, "body can not be null");
        HttpResponse<String> httpResponse = this.getResponse(this.toJson(navigableMap), string, string2, n);
        PushoverResponse pushoverResponse = new PushoverResponse().isSuccessful(false);
        pushoverResponse.httpStatus(httpResponse.statusCode()).response(httpResponse.body()).isSuccessful(httpResponse.statusCode() == 200).limit(this.getHeaderValue(httpResponse, "X-Limit-App-Limit").orElse(0L)).remaining(this.getHeaderValue(httpResponse, "X-Limit-App-Remaining").orElse(0L)).reset(this.getHeaderValue(httpResponse, "X-Limit-App-Reset").orElse(0L));
        return pushoverResponse;
    }

    private HttpResponse<String> getResponse(String string, String string2, String string3, int n) throws JPushoverException {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string2)).timeout(Duration.ofSeconds(5L)).header("Content-Type", "application/json").version(HttpClient.Version.HTTP_1_1).POST(HttpRequest.BodyPublishers.ofString(string)).build();
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1);
        if (string3 != null && n > 0) {
            builder.proxy(ProxySelector.of(new InetSocketAddress(string3, n)));
        }
        try {
            return builder.build().send(httpRequest, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new JPushoverException("Failed to execute HTTP request", exception);
        }
    }

    private String toJson(NavigableMap<String, String> navigableMap) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (Map.Entry entry : navigableMap.entrySet()) {
            stringBuilder.append("\"").append((String)entry.getKey()).append("\"");
            stringBuilder.append(":");
            stringBuilder.append("\"").append((String)entry.getValue()).append("\"");
            stringBuilder.append(",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString().replace(",}", "}");
    }

    private OptionalLong getHeaderValue(HttpResponse<String> httpResponse, String string) {
        return httpResponse.headers().firstValueAsLong(string);
    }
}

