/*
 * Decompiled with CFR 0.152.
 */
package de.SweetCode.SteamAPI;

import de.SweetCode.SteamAPI.interfaces.IAccountRecoveryService;
import de.SweetCode.SteamAPI.interfaces.IBroadcastService;
import de.SweetCode.SteamAPI.interfaces.ICheatReportingService;
import de.SweetCode.SteamAPI.interfaces.IEconMarketService;
import de.SweetCode.SteamAPI.interfaces.IEconService;
import de.SweetCode.SteamAPI.interfaces.IGameInventory;
import de.SweetCode.SteamAPI.interfaces.IGameNotificationsService;
import de.SweetCode.SteamAPI.interfaces.IGameServersService;
import de.SweetCode.SteamAPI.interfaces.IInventoryService;
import de.SweetCode.SteamAPI.interfaces.IPlayerService;
import de.SweetCode.SteamAPI.interfaces.ISteamApps;
import de.SweetCode.SteamAPI.interfaces.ISteamCDN;
import de.SweetCode.SteamAPI.interfaces.ISteamCommunity;
import de.SweetCode.SteamAPI.interfaces.ISteamDirectory;
import de.SweetCode.SteamAPI.interfaces.ISteamGameServerStats;
import de.SweetCode.SteamAPI.interfaces.ISteamLeaderboards;
import de.SweetCode.SteamAPI.interfaces.ISteamNews;
import de.SweetCode.SteamAPI.interfaces.ISteamRemoteStorage;
import de.SweetCode.SteamAPI.interfaces.ISteamSpecialSurvey;
import de.SweetCode.SteamAPI.interfaces.ISteamUser;
import de.SweetCode.SteamAPI.interfaces.ISteamUserAuth;
import de.SweetCode.SteamAPI.interfaces.ISteamUserOAuth;
import de.SweetCode.SteamAPI.interfaces.ISteamVideo;
import de.SweetCode.SteamAPI.interfaces.ISteamWebAPIUtil;
import de.SweetCode.SteamAPI.interfaces.ISteamWebUserPresenceOAuth;
import de.SweetCode.SteamAPI.interfaces.ISteamWorkshop;
import de.SweetCode.SteamAPI.interfaces.SteamInterface;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;

public class SteamAPI {
    private final String key;
    private Map<Class<? extends SteamInterface>, SteamInterface> interfaces = new HashMap<Class<? extends SteamInterface>, SteamInterface>();
    private final OkHttpClient client;

    public SteamAPI(OkHttpClient client, String key) {
        assert (client != null);
        this.client = client;
        this.key = key;
        this.interfaces.put(IAccountRecoveryService.class, new IAccountRecoveryService(this));
        this.interfaces.put(IBroadcastService.class, new IBroadcastService(this));
        this.interfaces.put(ICheatReportingService.class, new ICheatReportingService(this));
        this.interfaces.put(IEconMarketService.class, new IEconMarketService(this));
        this.interfaces.put(IEconService.class, new IEconService(this));
        this.interfaces.put(IGameNotificationsService.class, new IGameNotificationsService(this));
        this.interfaces.put(IGameServersService.class, new IGameServersService(this));
        this.interfaces.put(IGameInventory.class, new IGameInventory(this));
        this.interfaces.put(IInventoryService.class, new IInventoryService(this));
        this.interfaces.put(IPlayerService.class, new IPlayerService(this));
        this.interfaces.put(ISteamApps.class, new ISteamApps(this));
        this.interfaces.put(ISteamCDN.class, new ISteamCDN(this));
        this.interfaces.put(ISteamCommunity.class, new ISteamCommunity(this));
        this.interfaces.put(ISteamDirectory.class, new ISteamDirectory(this));
        this.interfaces.put(ISteamGameServerStats.class, new ISteamGameServerStats(this));
        this.interfaces.put(ISteamLeaderboards.class, new ISteamLeaderboards(this));
        this.interfaces.put(ISteamNews.class, new ISteamNews(this));
        this.interfaces.put(ISteamRemoteStorage.class, new ISteamRemoteStorage(this));
        this.interfaces.put(ISteamSpecialSurvey.class, new ISteamSpecialSurvey(this));
        this.interfaces.put(ISteamUser.class, new ISteamUser(this));
        this.interfaces.put(ISteamUserAuth.class, new ISteamUserAuth(this));
        this.interfaces.put(ISteamUserOAuth.class, new ISteamUserOAuth(this));
        this.interfaces.put(ISteamVideo.class, new ISteamVideo(this));
        this.interfaces.put(ISteamWebAPIUtil.class, new ISteamWebAPIUtil(this));
        this.interfaces.put(ISteamWebUserPresenceOAuth.class, new ISteamWebUserPresenceOAuth(this));
        this.interfaces.put(ISteamWorkshop.class, new ISteamWorkshop(this));
    }

    public SteamAPI(String key) {
        this(new OkHttpClient(), key);
    }

    public String getKey() {
        return this.key;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public <T extends SteamInterface> T get(Class<T> steamInterface) {
        assert (this.interfaces.containsKey(steamInterface));
        return (T)this.interfaces.get(steamInterface);
    }

    public void close() {
        this.client.dispatcher().executorService().shutdown();
        this.client.dispatcher().cancelAll();
    }
}

