/*
 * Decompiled with CFR 0.152.
 */
package de.SweetCode.SteamAPI.interfaces;

import de.SweetCode.SteamAPI.SteamAPI;
import de.SweetCode.SteamAPI.method.SteamMethod;
import java.util.HashMap;
import java.util.Map;

public abstract class SteamInterface {
    private final SteamAPI steam;
    private final String name;
    private final Map<Class<? extends SteamMethod>, SteamMethod> steamMethods = new HashMap<Class<? extends SteamMethod>, SteamMethod>();

    public SteamInterface(SteamAPI steam, String name) {
        assert (steam != null);
        assert (name != null);
        this.steam = steam;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SteamAPI getSteam() {
        return this.steam;
    }

    public Map<Class<? extends SteamMethod>, SteamMethod> getMethods() {
        return this.steamMethods;
    }

    public <T extends SteamMethod> T get(Class<T> method) {
        assert (method != null);
        assert (this.steamMethods.containsKey(method));
        return (T)this.steamMethods.get(method);
    }

    public void add(SteamMethod method) {
        assert (method != null);
        assert (!this.steamMethods.containsKey(method.getClass()));
        this.steamMethods.put(method.getClass(), method);
    }
}

