/*
 * Decompiled with CFR 0.152.
 */
package de.SweetCode.SteamAPI.method;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.SweetCode.SteamAPI.SteamHTTPMethod;
import de.SweetCode.SteamAPI.SteamHost;
import de.SweetCode.SteamAPI.SteamVersion;
import de.SweetCode.SteamAPI.SteamVisibility;
import de.SweetCode.SteamAPI.exceptions.SteamCombinationException;
import de.SweetCode.SteamAPI.interfaces.SteamInterface;
import de.SweetCode.SteamAPI.method.SteamMethodVersion;
import de.SweetCode.SteamAPI.method.SteamResponse;
import de.SweetCode.SteamAPI.method.input.Input;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public abstract class SteamMethod {
    private static final Gson GSON = new Gson();
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private SteamInterface steamInterface;
    private final String name;
    private final List<SteamMethodVersion> versions;

    public SteamMethod(SteamInterface steamInterface, String name, List<SteamMethodVersion> versions) {
        this.steamInterface = steamInterface;
        this.name = name;
        this.versions = versions;
    }

    public String getName() {
        return this.name;
    }

    public SteamInterface getInterface() {
        return this.steamInterface;
    }

    public Set<SteamHTTPMethod> getSupportedMethods() {
        HashSet<SteamHTTPMethod> values = new HashSet<SteamHTTPMethod>();
        this.versions.forEach(e -> values.add(e.getMethod()));
        return values;
    }

    public Set<SteamHost> getSupportedHosts() {
        HashSet<SteamHost> values = new HashSet<SteamHost>();
        this.versions.forEach(e -> values.addAll(e.getHosts()));
        return values;
    }

    public Set<SteamVersion> getSupportedVersions() {
        HashSet<SteamVersion> values = new HashSet<SteamVersion>();
        this.versions.forEach(e -> values.add(e.getVersion()));
        return values;
    }

    public Set<SteamVisibility> getSupportedVisibilities() {
        HashSet<SteamVisibility> values = new HashSet<SteamVisibility>();
        this.versions.forEach(e -> values.add(e.getVisibility()));
        return values;
    }

    public List<SteamMethodVersion> getVersions() {
        return this.versions;
    }

    public Optional<SteamMethodVersion> get(SteamHTTPMethod method, SteamHost host, SteamVersion version, SteamVisibility visibility) {
        return this.versions.stream().filter(e -> e.getMethod() == method && e.getHosts().contains((Object)host) && e.getVersion() == version && (e.getVisibility() == SteamVisibility.ALL || e.getVisibility() == visibility)).findAny();
    }

    public boolean supports(SteamHTTPMethod method) {
        return this.versions.stream().anyMatch(e -> e.getMethod() == method);
    }

    public boolean supports(SteamHost host) {
        return this.versions.stream().anyMatch(e -> e.getHosts().contains((Object)host));
    }

    public boolean supports(SteamVersion version) {
        return this.versions.stream().anyMatch(e -> e.getVersion() == version);
    }

    public boolean supports(SteamVisibility visibility) {
        return this.versions.stream().anyMatch(e -> e.getVisibility() == visibility);
    }

    private void verify(SteamHTTPMethod method, SteamHost host, SteamVersion version, SteamVisibility visibility) {
        if (method == null) {
            throw new IllegalArgumentException("The SteamHTTPMethod cannot be null.");
        }
        if (!this.supports(method)) {
            throw new IllegalArgumentException(String.format("The SteamMethod %s DOES NOT support the provided HTTP request method %s. The method only supports: %s.", this.getName(), method.name(), StringUtils.join(this.getSupportedMethods(), (String)", ")));
        }
        if (host == null) {
            throw new IllegalArgumentException("The SteamHost cannot be null.");
        }
        if (!this.supports(host)) {
            throw new IllegalArgumentException(String.format("The SteamMethod %s DOES NOT support the provided host %s. The method only supports: %s.", this.getName(), host.name(), StringUtils.join(this.getSupportedHosts(), (String)", ")));
        }
        if (version == null) {
            throw new IllegalArgumentException("The SteamVersion cannot be null.");
        }
        if (!this.supports(version)) {
            throw new IllegalArgumentException(String.format("The SteamMethod %s DOES NOT support the provided version %s. The method only supports: %s.", this.getName(), version.name(), StringUtils.join(this.getSupportedVersions(), (String)", ")));
        }
        if (visibility == null) {
            throw new IllegalArgumentException("The SteamHTTPMethod cannot be null.");
        }
        if (!this.supports(visibility)) {
            throw new IllegalArgumentException(String.format("The SteamMethod %s DOES NOT support the provided visibility %s. The method only supports: %s.", visibility.name(), this.getSupportedVisibilities()));
        }
        if (!this.get(method, host, version, visibility).isPresent()) {
            throw new SteamCombinationException(this, method, host, version, visibility);
        }
    }

    public void execute(SteamHTTPMethod method, SteamHost host, SteamVersion version, SteamVisibility visibility, Input input, final SteamResponse callback, boolean async) {
        if (!input.contains("key") && this.getInterface().getSteam().getKey() != null) {
            input.add("key", this.getInterface().getSteam().getKey());
        }
        this.verify(method, host, version, visibility);
        SteamMethodVersion methodVersion = this.get(method, host, version, visibility).get();
        if (methodVersion.verify(this, host, input)) {
            block9: {
                final Request request = SteamMethod.buildRequest(this, method, host, version, input);
                try {
                    if (async) {
                        this.getInterface().getSteam().getClient().newCall(request).enqueue(new Callback(){

                            public void onFailure(Call call, IOException e) {
                                callback.onError(e.getMessage());
                            }

                            public void onResponse(Call call, Response response) {
                                Optional<JsonObject> parsedBody = Optional.empty();
                                try {
                                    parsedBody = Optional.ofNullable(GSON.fromJson(response.body().string(), JsonObject.class));
                                }
                                catch (JsonSyntaxException e) {
                                    callback.onResponse(request, response, Optional.empty());
                                    return;
                                }
                                catch (IOException e) {
                                    callback.onError(e.getMessage());
                                    return;
                                }
                                callback.onResponse(request, response, parsedBody);
                                response.close();
                            }
                        });
                        break block9;
                    }
                    Response response = this.getInterface().getSteam().getClient().newCall(request).execute();
                    Optional<JsonObject> parsedBody = Optional.empty();
                    if (response != null) {
                        try {
                            parsedBody = Optional.ofNullable(GSON.fromJson(response.body().string(), JsonObject.class));
                        }
                        catch (JsonSyntaxException e) {
                            callback.onResponse(request, response, Optional.empty());
                            return;
                        }
                        catch (IOException e) {
                            callback.onError(e.getMessage());
                            return;
                        }
                        callback.onResponse(request, response, parsedBody);
                        return;
                    }
                    callback.onError("Invalid response.");
                }
                catch (IOException e) {
                    callback.onError(e.getMessage());
                }
            }
            return;
        }
        throw new IllegalStateException("We never should hit this point. Please open a new issue on github.com/sweetcode/SteamAPI with details about the request. DO NOT forget to exclude your Steam API Key if you used one or one is visible in the code or information you are providing on GitHub.");
    }

    private static Request buildRequest(SteamMethod steamMethod, SteamHTTPMethod method, SteamHost host, SteamVersion version, Input input) {
        HttpUrl.Builder url = HttpUrl.parse((String)String.format("https://%s/%s/%s/%s/", host.getHost(), steamMethod.getInterface().getName(), steamMethod.getName(), version.getUrlVersion())).newBuilder();
        url.addQueryParameter("format", "json");
        Request.Builder builder = new Request.Builder();
        switch (method) {
            case GET: {
                builder.get();
                input.getValues().entrySet().forEach(e -> url.addQueryParameter((String)e.getKey(), String.valueOf(e.getValue())));
                break;
            }
            case POST: {
                JsonObject payload = new JsonObject();
                input.getValues().entrySet().forEach(e -> payload.addProperty((String)e.getKey(), String.valueOf(e.getValue())));
                builder.post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)GSON.toJson((JsonElement)payload)));
            }
        }
        builder.url(url.build());
        return builder.build();
    }
}

