/*
 * Decompiled with CFR 0.152.
 */
package de.SweetCode.SteamAPI.method;

import de.SweetCode.SteamAPI.SteamHTTPMethod;
import de.SweetCode.SteamAPI.SteamHost;
import de.SweetCode.SteamAPI.SteamVersion;
import de.SweetCode.SteamAPI.SteamVisibility;
import de.SweetCode.SteamAPI.exceptions.SteamDependencyException;
import de.SweetCode.SteamAPI.exceptions.SteamMissingInputException;
import de.SweetCode.SteamAPI.method.SteamMethod;
import de.SweetCode.SteamAPI.method.input.Input;
import de.SweetCode.SteamAPI.method.option.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SteamMethodVersion {
    private final SteamHTTPMethod httpMethod;
    private final List<SteamHost> hosts;
    private final SteamVersion version;
    private final SteamVisibility visibility;
    private final Map<String, Option> options = new TreeMap<String, Option>();

    public SteamMethodVersion(SteamHTTPMethod method, List<SteamHost> hosts, SteamVersion version, SteamVisibility visibility) {
        assert (method != null);
        assert (hosts != null);
        assert (!hosts.isEmpty());
        assert (version != null);
        assert (visibility != null);
        this.httpMethod = method;
        this.hosts = hosts;
        this.version = version;
        this.visibility = visibility;
    }

    public SteamHTTPMethod getMethod() {
        return this.httpMethod;
    }

    public List<SteamHost> getHosts() {
        return this.hosts;
    }

    public SteamVersion getVersion() {
        return this.version;
    }

    public SteamVisibility getVisibility() {
        return this.visibility;
    }

    public Option get(String key) {
        assert (key != null);
        assert (this.options.containsKey(key));
        return this.options.get(key);
    }

    public void add(Option option) {
        assert (option != null);
        assert (!this.options.containsKey(option.getKey()));
        this.options.put(option.getKey(), option);
    }

    public boolean verify(SteamMethod steamMethod, SteamHost host, Input input) {
        assert (steamMethod != null);
        assert (input != null);
        Map<String, Object> data = input.getValues();
        for (Map.Entry<String, Option> e : this.options.entrySet()) {
            String key = e.getKey();
            Option option = e.getValue();
            if ((option.isRequired() || host == SteamHost.PARTNER && option.isPartnerRequired()) && !data.containsKey(key)) {
                throw new SteamMissingInputException(steamMethod, option);
            }
            if (data.containsKey(key) && !option.getOptionType().check(data.get(key))) {
                throw new IllegalArgumentException(String.format("The method %s expected a %s for the key %s. The value %s doesn't fit the OptionType.", steamMethod.getName(), option.getOptionType().getName(), option.getKey(), String.valueOf(data.get(key))));
            }
            if (!data.containsKey(key)) continue;
            option.getDependencies().forEach(d -> {
                if (!data.containsKey(d)) {
                    throw new SteamDependencyException(steamMethod, option, (String)d);
                }
            });
        }
        return true;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private SteamHTTPMethod method = null;
        private List<SteamHost> hosts = null;
        private SteamVersion version = null;
        private SteamVisibility visibility = null;
        private List<Option> collection = new ArrayList<Option>();

        public Builder method(SteamHTTPMethod method) {
            this.method = method;
            return this;
        }

        public Builder hosts(SteamHost ... hosts) {
            this.hosts = Arrays.asList(hosts);
            return this;
        }

        public Builder version(SteamVersion version) {
            this.version = version;
            return this;
        }

        public Builder visibility(SteamVisibility visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder add(Option option) {
            this.collection.add(option);
            return this;
        }

        public SteamMethodVersion build() {
            SteamMethodVersion steamMethodVersion = new SteamMethodVersion(this.method, this.hosts, this.version, this.visibility);
            this.collection.forEach(steamMethodVersion::add);
            return steamMethodVersion;
        }
    }
}

