/*
 * Decompiled with CFR 0.152.
 */
package de.SweetCode.SteamAPI.method.option;

import de.SweetCode.SteamAPI.method.option.OptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Option {
    private final String key;
    private final Optional<String> description;
    private final OptionType optionType;
    private final boolean required;
    private final boolean partnerRequired;
    private final List<String> dependencies;

    public Option(String key, List<String> dependencies, String description, OptionType optionType, boolean required, boolean partnerRequired) {
        assert (key != null);
        assert (dependencies != null);
        assert (optionType != null);
        this.key = key;
        this.dependencies = dependencies;
        this.description = Optional.ofNullable(description);
        this.optionType = optionType;
        this.required = required;
        this.partnerRequired = partnerRequired;
    }

    public Option(String key, String description, OptionType optionType, boolean required, boolean partnerRequired) {
        this(key, new ArrayList<String>(), description, optionType, required, partnerRequired);
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public OptionType getOptionType() {
        return this.optionType;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isPartnerRequired() {
        return this.partnerRequired;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private String key = null;
        private String description = null;
        private OptionType optionType = null;
        private boolean isRequired = false;
        private boolean isPartnerRequired = false;
        private final List<String> dependencies = new ArrayList<String>();

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder addDependecy(String key) {
            this.dependencies.add(key);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder optionType(OptionType optionType) {
            this.optionType = optionType;
            return this;
        }

        public Builder isRequired(boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public Builder isPartnerRequired(boolean isPartnerRequired) {
            this.isPartnerRequired = isPartnerRequired;
            return this;
        }

        public Option build() {
            return new Option(this.key, this.dependencies, this.description, this.optionType, this.isRequired, this.isPartnerRequired);
        }
    }
}

