/*
 * Decompiled with CFR 0.152.
 */
package de.SweetCode.SteamAPI.method.option;

import de.SweetCode.SteamAPI.method.option.OptionType;

public enum OptionTypes implements OptionType
{
    STRING{

        @Override
        public String getName() {
            return "String";
        }

        @Override
        public boolean check(Object value) {
            return value != null && value instanceof String;
        }

        public String parse(Object value) {
            return (String)value;
        }
    }
    ,
    UINT_32{

        @Override
        public String getName() {
            return "uint32";
        }

        @Override
        public boolean check(Object value) {
            return value != null && (value instanceof Long && (Long)value >= 0L && (Long)value <= 0xFFFFFFFFL || value instanceof Integer && (Integer)value >= 0 || value instanceof Short && (Short)value >= 0);
        }

        public Long parse(Object value) {
            return Math.abs((Long)value);
        }
    }
    ,
    UINT_64{

        @Override
        public String getName() {
            return "uint64";
        }

        @Override
        public boolean check(Object value) {
            return value != null && value instanceof Long;
        }

        public Object parse(Object value) {
            return Math.abs((Long)value);
        }
    }
    ,
    INT_32{

        @Override
        public String getName() {
            return "int32";
        }

        @Override
        public boolean check(Object value) {
            return value != null && value instanceof Integer;
        }

        public Integer parse(Object value) {
            return (int)((Integer)value);
        }
    }
    ,
    INT_64{

        @Override
        public String getName() {
            return "int64";
        }

        @Override
        public boolean check(Object value) {
            return value != null && value instanceof Long;
        }

        public Long parse(Object value) {
            return (long)((Long)value);
        }
    }
    ,
    FLOAT{

        @Override
        public String getName() {
            return "float";
        }

        @Override
        public boolean check(Object value) {
            return value != null && value instanceof Float;
        }

        public Float parse(Object value) {
            return Float.valueOf(((Float)value).floatValue());
        }
    }
    ,
    BOOL{

        @Override
        public String getName() {
            return "bool";
        }

        @Override
        public boolean check(Object value) {
            return value != null && value instanceof Boolean;
        }

        public Boolean parse(Object value) {
            return (boolean)((Boolean)value);
        }
    }
    ,
    RAW_BINARY{

        @Override
        public String getName() {
            return "raw-binary";
        }

        @Override
        public boolean check(Object value) {
            return value != null && value instanceof byte[];
        }

        public byte[] parse(Object value) {
            return (byte[])value;
        }
    };

}

