/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret.handlers;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.secret.interfaces.Collection;
import org.freedesktop.secret.interfaces.Prompt;
import org.freedesktop.secret.interfaces.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHandler
implements DBusSigHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private DBusConnection connection = null;
    private List<Class<? extends DBusSignal>> registered = new ArrayList<Class<? extends DBusSignal>>();
    private DBusSignal[] handled = new DBusSignal[250];
    private int count = 0;

    private SignalHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.disconnect()));
    }

    public static SignalHandler getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public void connect(DBusConnection connection, List<Class<? extends DBusSignal>> signals) {
        if (this.connection == null) {
            this.connection = connection;
        }
        if (signals != null) {
            try {
                for (Class<? extends DBusSignal> sc : signals) {
                    if (this.registered.contains(sc)) continue;
                    connection.addSigHandler(sc, (DBusSigHandler)this);
                    this.registered.add(sc);
                }
            }
            catch (DBusException e) {
                this.log.error(e.toString(), e.getCause());
            }
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.log.debug("remove signal handlers");
                for (Class<? extends DBusSignal> sc : this.registered) {
                    if (!this.connection.isConnected()) continue;
                    this.log.trace("remove signal handler: " + sc.getName());
                    this.connection.removeSigHandler(sc, (DBusSigHandler)this);
                }
            }
            catch (DBusException e) {
                this.log.error(e.toString(), e.getCause());
            }
        }
    }

    public void handle(DBusSignal s) {
        Collections.rotate(Arrays.asList(this.handled), 1);
        this.handled[0] = s;
        ++this.count;
        if (s instanceof Collection.ItemCreated) {
            Collection.ItemCreated ic = (Collection.ItemCreated)s;
            this.log.info("Collection.ItemCreated: " + ic.item);
        } else if (s instanceof Collection.ItemChanged) {
            Collection.ItemChanged ic = (Collection.ItemChanged)s;
            this.log.info("Collection.ItemChanged: " + ic.item);
        } else if (s instanceof Collection.ItemDeleted) {
            Collection.ItemDeleted ic = (Collection.ItemDeleted)s;
            this.log.info("Collection.ItemDeleted: " + ic.item);
        } else if (s instanceof Prompt.Completed) {
            Prompt.Completed c = (Prompt.Completed)s;
            this.log.info("Prompt.Completed (" + s.getPath() + "): {dismissed: " + c.dismissed + ", result: " + c.result + "}");
        } else if (s instanceof Service.CollectionCreated) {
            Service.CollectionCreated cc = (Service.CollectionCreated)s;
            this.log.info("Service.CollectionCreated: " + cc.collection);
        } else if (s instanceof Service.CollectionChanged) {
            Service.CollectionChanged cc = (Service.CollectionChanged)s;
            this.log.info("Service.CollectionChanged: " + cc.collection);
        } else if (s instanceof Service.CollectionDeleted) {
            Service.CollectionDeleted cc = (Service.CollectionDeleted)s;
            this.log.info("Service.CollectionDeleted: " + cc.collection);
        } else {
            this.log.warn("Handled unknown signal: " + s.getClass().toString() + " {" + s.toString() + "}");
        }
    }

    public DBusSignal[] getHandledSignals() {
        return this.handled;
    }

    public <S extends DBusSignal> List<S> getHandledSignals(Class<S> s) {
        return Arrays.stream(this.handled).filter(signal -> signal != null).filter(signal -> signal.getClass().equals(s)).map(signal -> signal).collect(Collectors.toList());
    }

    public <S extends DBusSignal> List<S> getHandledSignals(Class<S> s, String path) {
        return Arrays.stream(this.handled).filter(signal -> signal != null).filter(signal -> signal.getClass().equals(s)).filter(signal -> signal.getPath().equals(path)).map(signal -> signal).collect(Collectors.toList());
    }

    public int getCount() {
        return this.count;
    }

    public DBusSignal getLastHandledSignal() {
        return this.handled[0];
    }

    public <S extends DBusSignal> S getLastHandledSignal(Class<S> s) {
        return (S)((DBusSignal)this.getHandledSignals(s).get(0));
    }

    public <S extends DBusSignal> S getLastHandledSignal(Class<S> s, String path) {
        return (S)((DBusSignal)this.getHandledSignals(s, path).get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends DBusSignal> S await(Class<S> s, String path, Callable action) {
        try {
            action.call();
        }
        catch (Exception e) {
            this.log.error(e.toString(), e.getCause());
        }
        int init = this.getHandledSignals(s, path).size();
        Duration timeout = Duration.ofSeconds(60L);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.log.info("await signal " + s.getName() + "(" + path + ") within " + timeout.getSeconds() + " seconds.");
        Future<Object> handler = executor.submit(() -> {
            int await = init;
            List signals = null;
            while (await == init) {
                Thread.sleep(50L);
                signals = this.getHandledSignals(s, path);
                await = signals.size();
            }
            if (!signals.isEmpty()) {
                return signals.get(0);
            }
            return null;
        });
        try {
            DBusSignal dBusSignal = (DBusSignal)handler.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            return (S)dBusSignal;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            handler.cancel(true);
            this.log.error(e.toString(), e.getCause());
        }
        finally {
            executor.shutdownNow();
        }
        return null;
    }

    private static class SingletonHelper {
        private static final SignalHandler INSTANCE = new SignalHandler();

        private SingletonHelper() {
        }
    }
}

