/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.secret.Service;
import org.freedesktop.secret.Static;
import org.freedesktop.secret.errors.NoSuchObject;
import org.freedesktop.secret.handlers.Messaging;
import org.freedesktop.secret.interfaces.Prompt;

public class Prompt
extends Messaging
implements org.freedesktop.secret.interfaces.Prompt {
    public static final List<Class<? extends DBusSignal>> signals = Arrays.asList(Prompt.Completed.class);

    public Prompt(Service service) {
        super(service.getConnection(), signals, "org.freedesktop.secrets", "/", "org.freedesktop.Secret.Prompt");
    }

    @Override
    public void prompt(String window_id) {
        this.objectPath = Static.ObjectPaths.prompt(window_id);
        this.send("Prompt", "s", window_id);
    }

    @Override
    public void prompt(ObjectPath prompt) throws NoSuchObject {
        this.objectPath = prompt.getPath();
        if (!this.objectPath.startsWith("/org/freedesktop/secrets/prompt/p") && !this.objectPath.startsWith("/org/freedesktop/secrets/prompt/u")) {
            throw new NoSuchObject(this.objectPath);
        }
        String[] split = prompt.getPath().split("/");
        String window_id = split[split.length - 1];
        this.send("Prompt", "s", window_id);
    }

    public Prompt.Completed await(ObjectPath path, Duration timeout) {
        if ("/".equals(path.getPath())) {
            return this.sh.getLastHandledSignal(Prompt.Completed.class);
        }
        return this.sh.await(Prompt.Completed.class, path.getPath(), () -> {
            this.prompt(path);
            return this;
        }, timeout);
    }

    public Prompt.Completed await(ObjectPath path) {
        return this.await(path, Static.DEFAULT_TIMEOUT);
    }

    @Override
    public void dismiss() {
        this.send("Dismiss", "", new Object[0]);
    }

    public boolean isRemote() {
        return false;
    }

    @Override
    public String getObjectPath() {
        return super.getObjectPath();
    }
}

