/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret.handlers;

import java.util.Arrays;
import java.util.concurrent.RejectedExecutionException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.secret.errors.IsLocked;
import org.freedesktop.secret.errors.NoSession;
import org.freedesktop.secret.errors.NoSuchObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private DBusConnection connection;

    public MessageHandler(DBusConnection connection) {
        this.connection = connection;
        if (this.connection != null) {
            this.connection.setWeakReferences(true);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    this.connection.disconnect();
                }
                catch (RejectedExecutionException e) {
                    this.log.error("Could not disconnect properly from the D-Bus.", (Throwable)e);
                }
            }));
        }
    }

    public Object[] send(String service, String path, String iface, String method, String signature, Object ... args) {
        try {
            MethodCall message = new MethodCall(service, path, iface, method, 0, signature, args);
            this.connection.sendMessage((Message)message);
            Message response = message.getReply(2000L);
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.valueOf(response));
            }
            if (response instanceof Error) {
                switch (response.getName()) {
                    case "org.freedesktop.Secret.Error.NoSession": {
                        throw new NoSession((String)response.getParameters()[0]);
                    }
                    case "org.freedesktop.Secret.Error.NoSuchObject": {
                        throw new NoSuchObject((String)response.getParameters()[0]);
                    }
                    case "org.freedesktop.Secret.Error.IsLocked": {
                        throw new IsLocked((String)response.getParameters()[0]);
                    }
                    case "org.freedesktop.DBus.Error.NoReply": {
                        this.log.warn("org.freedesktop.DBus.Error.NoReply");
                        break;
                    }
                    default: {
                        throw new DBusException(response.getName() + ": " + response.getParameters()[0]);
                    }
                }
            }
            Object[] parameters = response.getParameters();
            this.log.debug(Arrays.deepToString(parameters));
            return parameters;
        }
        catch (DBusException | IsLocked | NoSession | NoSuchObject e) {
            this.log.error("D-Bus response:", e);
            return null;
        }
    }

    public Variant getProperty(String service, String path, String iface, String property) {
        Object[] response = this.send(service, path, "org.freedesktop.DBus.Properties", "Get", "ss", iface, property);
        if (response == null) {
            return null;
        }
        return (Variant)response[0];
    }

    public Variant getAllProperties(String service, String path, String iface) {
        Object[] response = this.send(service, path, "org.freedesktop.DBus.Properties", "GetAll", "ss", iface);
        if (response == null) {
            return null;
        }
        return (Variant)response[0];
    }

    public void setProperty(String service, String path, String iface, String property, Variant value) {
        this.send(service, path, "org.freedesktop.DBus.Properties", "Set", "ssv", iface, property, value);
    }

    public DBusConnection getConnection() {
        return this.connection;
    }
}

