/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret;

import at.favre.lib.crypto.HKDF;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.secret.Pair;
import org.freedesktop.secret.Secret;
import org.freedesktop.secret.Service;
import org.freedesktop.secret.Static;

public class TransportEncryption
implements AutoCloseable {
    public static final int PRIVATE_VALUE_BITS = 1024;
    public static final int AES_BITS = 128;
    private Service service;
    private DHParameterSpec dhParameters = null;
    private KeyPair keypair = null;
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;
    private SecretKey sessionKey = null;
    private byte[] yb = null;

    public TransportEncryption() throws DBusException {
        DBusConnection connection = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        this.service = new Service(connection);
    }

    public TransportEncryption(DBusConnection connection) {
        this.service = new Service(connection);
    }

    public TransportEncryption(Service service) {
        this.service = service;
    }

    private static BigInteger fromBinary(byte[] bytes) {
        return new BigInteger(1, bytes);
    }

    private static int toBytes(int bits) {
        return bits / 8;
    }

    public void initialize() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        BigInteger prime = TransportEncryption.fromBinary(Static.RFC_2409.SecondOakleyGroup.PRIME);
        BigInteger generator = TransportEncryption.fromBinary(Static.RFC_2409.SecondOakleyGroup.GENERATOR);
        this.dhParameters = new DHParameterSpec(prime, generator, 1024);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
        keyPairGenerator.initialize(this.dhParameters);
        this.keypair = keyPairGenerator.generateKeyPair();
        this.publicKey = this.keypair.getPublic();
        this.privateKey = this.keypair.getPrivate();
    }

    public void openSession() throws DBusException {
        if (this.keypair == null) {
            throw new IllegalStateException("Missing own keypair. Call initialize() first.");
        }
        BigInteger ya = ((DHPublicKey)this.publicKey).getY();
        Pair<Variant<byte[]>, ObjectPath> osResponse = this.service.openSession("dh-ietf1024-sha256-aes128-cbc-pkcs7", new Variant((Object)ya.toByteArray()));
        this.yb = (byte[])((Variant)osResponse.a).getValue();
    }

    public void generateSessionKey() throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        if (this.yb == null) {
            throw new IllegalStateException("Missing peer public key. Call openSession() first.");
        }
        DHPublicKeySpec dhPublicKeySpec = new DHPublicKeySpec(TransportEncryption.fromBinary(this.yb), this.dhParameters.getP(), this.dhParameters.getG());
        KeyFactory keyFactory = KeyFactory.getInstance("DH");
        DHPublicKey peerPublicKey = (DHPublicKey)keyFactory.generatePublic(dhPublicKeySpec);
        KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
        keyAgreement.init(this.privateKey);
        keyAgreement.doPhase(peerPublicKey, true);
        byte[] rawSessionKey = keyAgreement.generateSecret();
        byte[] pseudoRandomKey = HKDF.fromHmacSha256().extract((byte[])null, rawSessionKey);
        byte[] keyingMaterial = HKDF.fromHmacSha256().expand(pseudoRandomKey, null, TransportEncryption.toBytes(128));
        this.sessionKey = new SecretKeySpec(keyingMaterial, "AES");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Secret encrypt(CharSequence plain) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] bytes = Secret.toBytes(plain);
        try {
            Secret secret = this.encrypt(bytes, StandardCharsets.UTF_8);
            return secret;
        }
        finally {
            Secret.clear(bytes);
        }
    }

    public Secret encrypt(byte[] plain, Charset charset) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (plain == null) {
            return null;
        }
        if (this.service == null) {
            throw new IllegalStateException("Missing session. Call openSession() first.");
        }
        if (this.sessionKey == null) {
            throw new IllegalStateException("Missing session key. Call generateSessionKey() first.");
        }
        byte[] salt = new byte[TransportEncryption.toBytes(128)];
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.nextBytes(salt);
        IvParameterSpec ivSpec = new IvParameterSpec(salt);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)this.sessionKey, ivSpec);
        String contentType = Secret.createContentType(charset);
        return new Secret(this.service.getSession().getPath(), ivSpec.getIV(), cipher.doFinal(plain), contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] decrypt(Secret secret) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (secret == null) {
            return null;
        }
        if (this.sessionKey == null) {
            throw new IllegalStateException("Missing session key. Call generateSessionKey() first.");
        }
        IvParameterSpec ivSpec = new IvParameterSpec(secret.getSecretParameters());
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)this.sessionKey, ivSpec);
        byte[] decrypted = cipher.doFinal(secret.getSecretValue());
        try {
            char[] cArray = Secret.toChars(decrypted);
            return cArray;
        }
        finally {
            Secret.clear(decrypted);
        }
    }

    public Service getService() {
        return this.service;
    }

    public void clear() {
        if (this.privateKey != null) {
            try {
                this.privateKey.destroy();
            }
            catch (DestroyFailedException e) {
                Secret.clear(this.privateKey.getEncoded());
            }
        }
        if (this.sessionKey != null) {
            try {
                this.sessionKey.destroy();
            }
            catch (DestroyFailedException e) {
                Secret.clear(this.sessionKey.getEncoded());
            }
        }
    }

    @Override
    public void close() {
        this.clear();
    }
}

