/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret.simple;

import java.io.IOException;
import java.security.AccessControlException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.secret.Collection;
import org.freedesktop.secret.Item;
import org.freedesktop.secret.Pair;
import org.freedesktop.secret.Prompt;
import org.freedesktop.secret.Secret;
import org.freedesktop.secret.Service;
import org.freedesktop.secret.Session;
import org.freedesktop.secret.Static;
import org.freedesktop.secret.TransportEncryption;
import org.freedesktop.secret.interfaces.Collection;
import org.freedesktop.secret.interfaces.Prompt;
import org.freedesktop.secret.interfaces.Service;
import org.gnome.keyring.InternalUnsupportedGuiltRiddenInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleCollection
extends org.freedesktop.secret.simple.interfaces.SimpleCollection {
    private static final Logger log = LoggerFactory.getLogger(SimpleCollection.class);
    private static boolean testing = false;
    private static Lock disconnectLock = new ReentrantLock();
    private static DBusConnection connection = SimpleCollection.getConnection();
    private TransportEncryption transport;
    private Service service;
    private Session session;
    private Prompt prompt;
    private InternalUnsupportedGuiltRiddenInterface withoutPrompt;
    private Collection collection;
    private Secret encrypted;
    private Duration timeout;
    private Boolean isUnlockedOnceWithUserPermission;
    private String collectionLabel;

    public SimpleCollection() throws IOException {
        this.transport = null;
        this.service = null;
        this.session = null;
        this.prompt = null;
        this.withoutPrompt = null;
        this.encrypted = null;
        this.timeout = Static.DEFAULT_PROMPT_TIMEOUT;
        this.isUnlockedOnceWithUserPermission = false;
        this.collectionLabel = "";
        try {
            this.init();
            ObjectPath path = Static.Convert.toObjectPath("/org/freedesktop/secrets/aliases/default");
            this.collection = new Collection((DBusPath)path, this.service);
        }
        catch (RuntimeException e) {
            throw new IOException("Could not initialize the secret service.", e);
        }
    }

    public SimpleCollection(String label, CharSequence password) throws IOException {
        block14: {
            this.transport = null;
            this.service = null;
            this.session = null;
            this.prompt = null;
            this.withoutPrompt = null;
            this.encrypted = null;
            this.timeout = Static.DEFAULT_PROMPT_TIMEOUT;
            this.isUnlockedOnceWithUserPermission = false;
            this.collectionLabel = "";
            try {
                this.init();
                if (password != null) {
                    try {
                        this.encrypted = this.transport.encrypt(password);
                    }
                    catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                        log.error("Could not establish transport encryption.", (Throwable)e);
                    }
                }
                if (this.exists(label)) {
                    ObjectPath path = this.getCollectionPath(label);
                    this.collection = new Collection((DBusPath)path, this.service);
                    break block14;
                }
                ObjectPath path = null;
                Map<String, Variant> properties = Collection.createProperties(label);
                if (password == null) {
                    Pair<ObjectPath, ObjectPath> response = this.service.createCollection(properties);
                    if (!"/".equals(((ObjectPath)response.a).getPath())) {
                        path = (DBusPath)response.a;
                    }
                    this.performPrompt((ObjectPath)response.b);
                } else if (this.encrypted != null) {
                    path = this.withoutPrompt.createWithMasterPassword(properties, this.encrypted);
                }
                if (path == null) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(Static.DBus.DEFAULT_DELAY_MILLIS);
                    }
                    catch (InterruptedException e) {
                        log.error("Unexpected interrupt while waiting for a CollectionCreated signal.", (Throwable)e);
                    }
                    Service.CollectionCreated cc = this.service.getSignalHandler().getLastHandledSignal(Service.CollectionCreated.class);
                    path = cc.collection;
                }
                if (path == null) {
                    throw new IOException("Could not acquire a path for the prompt.");
                }
                this.collection = new Collection((DBusPath)path, this.service);
            }
            catch (RuntimeException e) {
                throw new IOException("Could not initialize the secret service.", e);
            }
        }
    }

    private static final DBusConnection getConnection() {
        try {
            DBusConnection dBusConnection = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
            return dBusConnection;
        }
        catch (DBusException e) {
            if (e == null) {
                log.warn("Could not communicate properly with the D-Bus.");
            } else {
                log.warn("Could not communicate properly with the D-Bus: " + e.getMessage() + " (" + ((Object)((Object)e)).getClass().getSimpleName() + ")");
            }
        }
        finally {
            SimpleCollection.disconnect(false);
        }
        return null;
    }

    public static boolean isAvailable() {
        if (connection != null && connection.isConnected()) {
            try {
                DBus bus = (DBus)connection.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
                if (!Arrays.asList(bus.ListActivatableNames()).contains("org.freedesktop.DBus")) {
                    return false;
                }
                TransportEncryption transport = new TransportEncryption(connection);
                transport.initialize();
                boolean isSessionSupported = transport.openSession();
                transport.close();
                return isSessionSupported;
            }
            catch (ExceptionInInitializerError | DBusException e) {
                log.warn("The secret service is not available. You may want to install the `gnome-keyring` package. Is the `gnome-keyring-daemon` running?", e);
                return false;
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                log.error("The secret service could not be initialized as the service does not provide the expected transport encryption algorithm.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private static void disconnectSynchronized() {
        disconnectLock.lock();
        try {
            if (connection != null && connection.isConnected()) {
                connection.close();
                while (connection.isConnected()) {
                    Thread.sleep(Static.DBus.DEFAULT_DELAY_MILLIS);
                }
                connection = null;
                log.debug("Disconnected properly from the D-Bus.");
            }
        }
        catch (IOException | InterruptedException | RejectedExecutionException e) {
            log.error("Could not disconnect properly from the D-Bus.", (Throwable)e);
        }
        finally {
            disconnectLock.unlock();
        }
    }

    private static void disconnect(boolean now) {
        if (connection != null && connection.isConnected()) {
            if (now && !testing) {
                SimpleCollection.disconnectSynchronized();
            } else {
                Thread daemonThread = new Thread(() -> SimpleCollection.disconnectSynchronized());
                daemonThread.setName("secret-service:disconnect-shutdown");
                daemonThread.setDaemon(true);
                Runtime.getRuntime().addShutdownHook(daemonThread);
            }
        }
    }

    public static void setTesting(boolean testing) {
        SimpleCollection.testing = testing;
    }

    private void init() throws IOException {
        if (!SimpleCollection.isAvailable()) {
            throw new IOException("The secret service is not available.");
        }
        try {
            this.transport = new TransportEncryption(connection);
            this.transport.initialize();
            this.transport.openSession();
            this.transport.generateSessionKey();
            this.service = this.transport.getService();
            this.session = this.service.getSession();
            this.prompt = new Prompt(this.service);
            this.withoutPrompt = new InternalUnsupportedGuiltRiddenInterface(this.service);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | DBusException e) {
            throw new IOException("Cloud not initiate transport encryption.", e);
        }
    }

    private Map<ObjectPath, String> getLabels() {
        List<ObjectPath> collections = this.service.getCollections();
        HashMap<ObjectPath, String> labels = new HashMap<ObjectPath, String>();
        for (ObjectPath path : collections) {
            Collection c = new Collection((DBusPath)path, this.service, null);
            labels.put(path, c.getLabel());
        }
        return labels;
    }

    private boolean exists(String label) {
        Map<ObjectPath, String> labels = this.getLabels();
        return labels.containsValue(label);
    }

    private ObjectPath getCollectionPath(String label) {
        Map<ObjectPath, String> labels = this.getLabels();
        ObjectPath path = null;
        for (Map.Entry<ObjectPath, String> entry : labels.entrySet()) {
            ObjectPath p = entry.getKey();
            String l = entry.getValue();
            if (!label.equals(l)) continue;
            path = p;
            break;
        }
        return path;
    }

    private boolean isDefault() {
        if (connection != null && connection.isConnected()) {
            List<String> defaults = Arrays.asList(null, "login", "session", "default");
            return defaults.contains(this.collection.getId());
        }
        return false;
    }

    private void performPrompt(ObjectPath path) {
        if (!"/".equals(path.getPath())) {
            this.prompt.await(path, this.timeout);
        }
    }

    private Item getItem(String path) {
        if (path != null) {
            return new Item(Static.Convert.toObjectPath(path), this.service);
        }
        return null;
    }

    private List<ObjectPath> lockable() {
        return Arrays.asList(this.collection.getPath());
    }

    @Override
    public void lock() {
        if (this.collection != null && !this.collection.isLocked()) {
            this.service.lock(this.lockable());
            try {
                Thread.currentThread();
                Thread.sleep(Static.DBus.DEFAULT_DELAY_MILLIS);
            }
            catch (InterruptedException e) {
                log.error("Unexpected interrupt while waiting for a collection to lock.", (Throwable)e);
            }
        }
    }

    private void unlock() {
        if (this.collection != null && this.collection.isLocked()) {
            if (this.encrypted == null || this.isDefault()) {
                Pair<List<ObjectPath>, ObjectPath> response = this.service.unlock(this.lockable());
                this.performPrompt((ObjectPath)response.b);
                if (!this.collection.isLocked()) {
                    this.isUnlockedOnceWithUserPermission = true;
                }
            } else {
                this.withoutPrompt.unlockWithMasterPassword((DBusPath)this.collection.getPath(), this.encrypted);
            }
        }
    }

    @Override
    public void unlockWithUserPermission() throws AccessControlException {
        if (!this.isUnlockedOnceWithUserPermission.booleanValue() && this.isDefault()) {
            this.lock();
        }
        this.unlock();
        if (this.collection.isLocked()) {
            throw new AccessControlException("The collection was not unlocked with user permission.");
        }
    }

    @Override
    public void clear() {
        if (this.transport != null) {
            this.transport.clear();
        }
        if (this.encrypted != null) {
            this.encrypted.clear();
        }
    }

    @Override
    public void close() {
        this.clear();
        log.debug("Cleared secrets properly.");
        if (this.session != null) {
            this.session.close();
            log.debug("Closed session properly.");
        }
        SimpleCollection.disconnect(true);
    }

    @Override
    public void delete() throws AccessControlException {
        if (this.isDefault()) {
            throw new AccessControlException("Default collections may not be deleted with the simple API.");
        }
        ObjectPath promptPath = this.collection.delete();
        this.performPrompt(promptPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String createItem(String label, CharSequence password, Map<String, String> attributes) throws IllegalArgumentException {
        DBusPath item;
        block14: {
            if (password == null) {
                throw new IllegalArgumentException("The password may not be null.");
            }
            if (label == null) {
                throw new IllegalArgumentException("The label of the password may not be null.");
            }
            if (this.collection == null) return null;
            if (this.transport == null) {
                return null;
            }
            this.unlock();
            item = null;
            Map<String, Variant> properties = Item.createProperties(label, attributes);
            try (Secret secret = this.transport.encrypt(password);){
                Pair<ObjectPath, ObjectPath> response = this.collection.createItem(properties, secret, false);
                if (response == null) {
                    String string = null;
                    return string;
                }
                item = (DBusPath)response.a;
                if (!"/".equals(item.getPath())) break block14;
                Prompt.Completed completed = this.prompt.await((ObjectPath)response.b);
                if (!completed.dismissed) {
                    Collection.ItemCreated ic = this.collection.getSignalHandler().getLastHandledSignal(Collection.ItemCreated.class);
                    item = ic.item;
                }
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                log.error("Cloud not encrypt the secret.", (Throwable)e);
            }
        }
        if (null == item) return null;
        return item.getPath();
    }

    @Override
    public String createItem(String label, CharSequence password) throws IllegalArgumentException {
        return this.createItem(label, password, null);
    }

    @Override
    public void updateItem(String objectPath, String label, CharSequence password, Map<String, String> attributes) throws IllegalArgumentException {
        if (objectPath == null) {
            throw new IllegalArgumentException("The object path of the item may not be null.");
        }
        this.unlock();
        Item item = this.getItem(objectPath);
        if (label != null) {
            item.setLabel(label);
        }
        if (attributes != null) {
            item.setAttributes(attributes);
        }
        if (password != null) {
            try (Secret secret = this.transport.encrypt(password);){
                item.setSecret(secret);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                log.error("Cloud not encrypt the secret.", (Throwable)e);
            }
        }
    }

    @Override
    public String getLabel(String objectPath) {
        if (objectPath == null) {
            return null;
        }
        this.unlock();
        return this.getItem(objectPath).getLabel();
    }

    @Override
    public Map<String, String> getAttributes(String objectPath) {
        if (objectPath == null) {
            return null;
        }
        this.unlock();
        return this.getItem(objectPath).getAttributes();
    }

    @Override
    public List<String> getItems(Map<String, String> attributes) {
        if (attributes == null) {
            return null;
        }
        this.unlock();
        List<ObjectPath> objects = this.collection.searchItems(attributes);
        if (objects != null && !objects.isEmpty()) {
            return Static.Convert.toStrings(objects);
        }
        return null;
    }

    @Override
    public char[] getSecret(String objectPath) {
        if (objectPath == null) {
            return null;
        }
        this.unlock();
        Item item = this.getItem(objectPath);
        char[] decrypted = null;
        try (Secret secret = item.getSecret(this.session.getPath());){
            decrypted = this.transport.decrypt(secret);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error("Could not decrypt the secret.", (Throwable)e);
        }
        return decrypted;
    }

    @Override
    public Map<String, char[]> getSecrets() throws AccessControlException {
        this.unlockWithUserPermission();
        List<ObjectPath> items = this.collection.getItems();
        if (items == null) {
            return null;
        }
        HashMap<String, char[]> passwords = new HashMap<String, char[]>();
        for (ObjectPath item : items) {
            String path = item.getPath();
            passwords.put(path, this.getSecret(path));
        }
        return passwords;
    }

    @Override
    public void deleteItem(String objectPath) throws AccessControlException {
        if (objectPath == null) {
            throw new AccessControlException("Cannot delete an unknown item.");
        }
        this.unlockWithUserPermission();
        Item item = this.getItem(objectPath);
        ObjectPath promptPath = item.delete();
        this.performPrompt(promptPath);
    }

    @Override
    public void deleteItems(List<String> objectPaths) throws AccessControlException {
        this.unlockWithUserPermission();
        for (String item : objectPaths) {
            this.deleteItem(item);
        }
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public boolean isLocked() {
        if (connection != null && connection.isConnected()) {
            return this.collection.isLocked();
        }
        return true;
    }
}

