/*
 * Decompiled with CFR 0.152.
 */
package de.team33.libs.classes.v1;

import java.util.function.Function;
import java.util.stream.Stream;

public class Classes {
    private static final String NO_LINEAGE = "there is no proper lineage relationship from <%s> as superclass to <%s> as subclass";

    private static <E> Stream<E> stream(E subject) {
        return null == subject ? Stream.empty() : Stream.of(subject);
    }

    public static boolean isLineage(Class<?> superClass, Class<?> subClass) {
        return (superClass.isInterface() || !subClass.isInterface()) && superClass.isAssignableFrom(subClass);
    }

    public static int distance(Class<?> superClass, Class<?> subClass) {
        return Distance.of(superClass).from(subClass);
    }

    public static Stream<Class<?>> superior(Class<?> subject) {
        return null == subject ? Stream.empty() : Stream.concat(Stream.of(subject.getInterfaces()), Classes.stream(subject.getSuperclass()));
    }

    public static Stream<Class<?>> lineageClasses(Class<?> subject) {
        return null == subject ? Stream.empty() : Stream.concat(Classes.lineageClasses(subject.getSuperclass()), Stream.of(subject));
    }

    public static Stream<Class<?>> lineageHierarchy(Class<?> subject) {
        return null == subject ? Stream.empty() : Classes.streamLineageHierarchyIndistinct(subject).distinct();
    }

    private static Stream<Class<?>> streamLineageHierarchyIndistinct(Class<?> subject) {
        return Stream.concat(Classes.superior(subject).map(Classes::streamLineageHierarchyIndistinct).reduce(Stream::concat).orElseGet(Stream::empty), Stream.of(subject));
    }

    private static class Distance {
        private final Class<?> superClass;
        private final Function<Class<?>, Stream<Class<?>>> superClasses;

        private Distance(Class<?> superClass, Function<Class<?>, Stream<Class<?>>> superClasses) {
            this.superClass = superClass;
            this.superClasses = superClasses;
        }

        static Distance of(Class<?> superClass) {
            if (superClass.isInterface()) {
                return new Distance(superClass, Distance::superClassesOf);
            }
            return new Distance(superClass, Distance::superClassOf);
        }

        private static <E> Stream<E> streamOf(E nullable) {
            return null == nullable ? Stream.empty() : Stream.of(nullable);
        }

        private static Stream<Class<?>> superClassOf(Class<?> aClass) {
            return Distance.streamOf(aClass.getSuperclass());
        }

        private static Stream<Class<?>> superClassesOf(Class<?> aClass) {
            return Stream.concat(Stream.of(aClass.getInterfaces()), Distance.superClassOf(aClass));
        }

        private int from(Class<?> subClass) {
            try {
                return this.superClass.equals(subClass) ? 0 : 1 + this.from(this.superClasses.apply(subClass));
            }
            catch (NoLineageException e) {
                throw new IllegalArgumentException(String.format(Classes.NO_LINEAGE, this.superClass, subClass), e);
            }
        }

        private int from(Stream<Class<?>> subClasses) {
            return subClasses.filter(subClass -> Classes.isLineage(this.superClass, subClass)).map(this::from).reduce(Math::min).orElseThrow(() -> new NoLineageException());
        }

        private static class NoLineageException
        extends RuntimeException {
            private NoLineageException() {
            }
        }
    }

    public static interface Streaming
    extends Function<Class<?>, Stream<Class<?>>> {
        public static final Streaming SUPER_CLASS = subject -> Classes.access$100(subject.getSuperclass());
        public static final Streaming INTERFACES = subject -> Stream.of(subject.getInterfaces());
        public static final Streaming SUPERIOR = Classes::superior;
        public static final Streaming LINEAGE_CLASSES = Classes::lineageClasses;
        public static final Streaming LINEAGE_HIERARCHY = Classes::lineageHierarchy;
    }
}

