/*
 * Decompiled with CFR 0.152.
 */
package de.team33.libs.decision.v1;

import java.util.function.Function;
import java.util.function.Predicate;

public class Choice<P, R>
implements Function<P, R> {
    private final Predicate<P> condition;
    private final Function<P, R> positive;
    private final Function<P, R> negative;

    private Choice(Predicate<P> condition, Function<P, R> positive, Function<P, R> negative) {
        this.condition = condition;
        this.positive = positive;
        this.negative = negative;
    }

    public static <P> Condition<P> on(Predicate<P> condition) {
        return new Condition(condition);
    }

    @Override
    public final R apply(P parameter) {
        return (this.condition.test(parameter) ? this.positive : this.negative).apply(parameter);
    }

    public static class Condition<P> {
        private final Predicate<P> condition;

        private Condition(Predicate<P> condition) {
            this.condition = condition;
        }

        public final <R> Consequence<P, R> apply(Function<P, R> positive) {
            return negative -> new Choice(this.condition, positive, negative);
        }

        public final <R> Consequence<P, R> reply(R positive) {
            return this.apply(any -> positive);
        }
    }

    @FunctionalInterface
    public static interface Consequence<P, R> {
        public Choice<P, R> orApply(Function<P, R> var1);

        default public Choice<P, R> orReply(R negative) {
            return this.orApply(any -> negative);
        }
    }
}

