/*
 * Decompiled with CFR 0.152.
 */
package de.team33.libs.exceptional.v4;

import java.util.function.Function;

public class Handling<T extends Throwable> {
    private final T subject;
    private final Throwable cause;

    private Handling(T subject) {
        this.subject = subject;
        this.cause = ((Throwable)subject).getCause();
    }

    public static <T extends Throwable> Handling<T> of(T subject) {
        return new Handling<T>(subject);
    }

    private static <X extends Throwable> void throwIfPresent(X exception) throws X {
        if (null != exception) {
            throw exception;
        }
    }

    public final <X extends Throwable> Handling<T> throwMapped(Function<? super T, X> mapping) throws X {
        Handling.throwIfPresent((Throwable)mapping.apply(this.subject));
        return this;
    }

    public final <X extends Throwable> Handling<T> reThrowIf(Class<X> type) throws X {
        Handling.throwIfPresent(type.isInstance(this.subject) ? (Throwable)type.cast(this.subject) : null);
        return this;
    }

    public final <X extends Throwable> Handling<T> throwMappedCause(Function<Throwable, X> mapping) throws X {
        Handling.throwIfPresent((Throwable)mapping.apply(this.cause));
        return this;
    }

    public final <X extends Throwable> Handling<T> reThrowCauseIf(Class<X> type) throws X {
        Handling.throwIfPresent(type.isInstance(this.cause) ? (Throwable)type.cast(this.cause) : null);
        return this;
    }

    public final T fallback() {
        return this.subject;
    }
}

