/*
 * Decompiled with CFR 0.152.
 */
package de.team33.libs.mapping.v1;

import de.team33.libs.reflect.v4.Fields;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;

public final class FieldMapper<T> {
    private final Map<String, Field> fieldMap;

    private FieldMapper(Map<String, Field> fieldMap) {
        this.fieldMap = Collections.unmodifiableMap(new TreeMap<String, Field>(fieldMap));
    }

    public static Stage stage(Function<Class<?>, Map<String, Field>> mapping) {
        return new Stage(mapping);
    }

    public static <T> FieldMapper<T> simple(Class<T> type) {
        return FieldMapper.stage(Fields.Mapping.SIGNIFICANT_FLAT).apply(type);
    }

    public final Map<String, Object> map(final T subject) {
        return new AbstractMap<String, Object>(){
            private Set<Map.Entry<String, Object>> backing;
            {
                this.backing = new EntrySet(subject);
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return this.backing;
            }
        };
    }

    public final Function<T, T> copyTo(T target) {
        return origin -> this.mapTo(target).apply(this.map(origin));
    }

    public final Function<Map<?, ?>, T> mapTo(T target) {
        return map -> {
            this.fieldMap.forEach((name, field) -> {
                Object value = map.get(name);
                try {
                    field.set(target, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(String.format("Cannot set %s to value <%s>", field, value), e);
                }
            });
            return target;
        };
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private final Object subject;

        private EntrySet(Object subject) {
            this.subject = subject;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator(FieldMapper.this.fieldMap.entrySet().iterator());
        }

        @Override
        public int size() {
            return FieldMapper.this.fieldMap.size();
        }

        private Map.Entry<String, Object> newEntry(Map.Entry<String, Field> entry) {
            try {
                return new AbstractMap.SimpleImmutableEntry<String, Object>(entry.getKey(), entry.getValue().get(this.subject));
            }
            catch (IllegalAccessException caught) {
                throw new IllegalStateException(String.format("cannot get <%s> from subject <%s>", entry.getValue(), this.subject), caught);
            }
        }

        private class EntryIterator
        implements Iterator<Map.Entry<String, Object>> {
            private final Iterator<Map.Entry<String, Field>> backing;

            private EntryIterator(Iterator<Map.Entry<String, Field>> backing) {
                this.backing = backing;
            }

            @Override
            public boolean hasNext() {
                return this.backing.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                return EntrySet.this.newEntry(this.backing.next());
            }
        }
    }

    public static final class Stage {
        private final Function<Class<?>, Map<String, Field>> mapping;

        private Stage(Function<Class<?>, Map<String, Field>> mapping) {
            this.mapping = mapping;
        }

        public final <T> FieldMapper<T> apply(Class<T> type) {
            return new FieldMapper(this.mapping.apply(type));
        }
    }
}

