/*
 * Decompiled with CFR 0.152.
 */
package de.team33.libs.testing.v1;

import de.team33.libs.testing.v1.Parallel;
import de.team33.libs.testing.v1.Serial;
import de.team33.libs.testing.v1.XConsumer;
import de.team33.libs.testing.v1.XRunnable;
import java.util.List;

public interface Attempts<X extends Exception> {
    public static <X extends Exception> void tryParallel(int count, XRunnable<X> xRunnable) throws X {
        Attempts.runParallel(count, xRunnable).reThrowCaught();
    }

    public static <X extends Exception> void tryParallel(int count, XConsumer<Integer, X> xConsumer) throws X {
        Attempts.runParallel(count, xConsumer).reThrowCaught();
    }

    public static <X extends Exception> Attempts<X> runParallel(int count, XRunnable<X> xRunnable) {
        return Attempts.runParallel(count, (Integer i) -> xRunnable.run());
    }

    public static <X extends Exception> Attempts<X> runParallel(int count, XConsumer<Integer, X> xConsumer) {
        return new Parallel<X>(count, xConsumer).run();
    }

    public static <X extends Exception> void trySerial(int count, XRunnable<X> xRunnable) throws X {
        Attempts.runSerial(count, xRunnable).reThrowCaught();
    }

    public static <X extends Exception> void trySerial(int count, XConsumer<Integer, X> xConsumer) throws X {
        Attempts.runSerial(count, xConsumer).reThrowCaught();
    }

    public static <X extends Exception> Attempts<X> runSerial(int count, XRunnable<X> xRunnable) {
        return Attempts.runSerial(count, (Integer i) -> xRunnable.run());
    }

    public static <X extends Exception> Attempts<X> runSerial(int count, XConsumer<Integer, X> xConsumer) {
        return new Serial<X>(count, xConsumer).run();
    }

    public void reThrowCaught() throws X;

    public List<Throwable> getCaught();
}

