/*
 * Decompiled with CFR 0.152.
 */
package de.team33.libs.testing.v1;

import de.team33.libs.testing.v1.Attempts;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class AttemptsBase<X extends Exception>
implements Attempts<X> {
    private static final BinaryOperator<Throwable> ADD_SUPPRESSED = (a, b) -> {
        a.addSuppressed((Throwable)b);
        return a;
    };
    private final SortedMap<Category, List<Throwable>> backing = new TreeMap<Category, List<Throwable>>(Enum::compareTo);

    AttemptsBase() {
    }

    final synchronized void addCaught(Category category, Throwable caught) {
        this.backing.computeIfAbsent(category, c -> new LinkedList()).add(caught);
    }

    @Override
    public final void reThrowCaught() throws X {
        Throwable result = this.mapCaught(stream -> stream.reduce(ADD_SUPPRESSED).orElse(null));
        if (result instanceof Error) {
            throw (Error)result;
        }
        if (result instanceof RuntimeException) {
            throw (RuntimeException)result;
        }
        if (result != null) {
            throw (Exception)result;
        }
    }

    @Override
    public List<Throwable> getCaught() {
        return this.mapCaught(stream -> stream.collect(Collectors.toList()));
    }

    private <R> R mapCaught(Function<Stream<Throwable>, R> mapper) {
        return mapper.apply(this.backing.values().stream().flatMap(Collection::stream));
    }

    static enum Category {
        ERROR,
        UNCHECKED,
        CHECKED,
        ADDITIONAL;

    }
}

