/*
 * Decompiled with CFR 0.152.
 */
package de.team33.libs.testing.v1;

import de.team33.libs.testing.v1.AttemptsBase;
import de.team33.libs.testing.v1.XConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class Parallel<X extends Exception>
extends AttemptsBase<X> {
    private final List<Thread> threads;
    private final AtomicInteger index = new AtomicInteger(0);

    Parallel(int count, XConsumer<Integer, X> xConsumer) {
        this.threads = new ArrayList<Thread>(count);
        for (int i = 0; i < count; ++i) {
            this.threads.add(new Thread(() -> {
                try {
                    xConsumer.accept(this.index.getAndIncrement());
                }
                catch (Error caught) {
                    this.addCaught(AttemptsBase.Category.ERROR, caught);
                }
                catch (RuntimeException caught) {
                    this.addCaught(AttemptsBase.Category.UNCHECKED, caught);
                }
                catch (Throwable caught) {
                    this.addCaught(AttemptsBase.Category.CHECKED, caught);
                }
            }));
        }
    }

    final Parallel<X> run() {
        return super.joinThreads();
    }

    private Parallel<X> startThreads() {
        for (Thread thread : this.threads) {
            thread.start();
        }
        return this;
    }

    private Parallel<X> joinThreads() {
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                this.addCaught(AttemptsBase.Category.ADDITIONAL, new JoinException(e));
            }
        }
        return this;
    }

    private static class JoinException
    extends RuntimeException {
        private JoinException(InterruptedException cause) {
            super(cause.getMessage(), cause);
        }
    }
}

