/*
 * Decompiled with CFR 0.152.
 */
package de.team33.libs.testing.v1;

import de.team33.libs.testing.v1.AttemptsBase;
import de.team33.libs.testing.v1.XConsumer;

class Serial<X extends Exception>
extends AttemptsBase<X> {
    private final int count;
    private final XConsumer<Integer, X> xConsumer;

    Serial(int count, XConsumer<Integer, X> xConsumer) {
        this.count = count;
        this.xConsumer = xConsumer;
    }

    final Serial<X> run() {
        for (int i = 0; i < this.count; ++i) {
            try {
                this.xConsumer.accept(i);
                continue;
            }
            catch (Error caught) {
                this.addCaught(AttemptsBase.Category.ERROR, caught);
                continue;
            }
            catch (RuntimeException caught) {
                this.addCaught(AttemptsBase.Category.UNCHECKED, caught);
                continue;
            }
            catch (Throwable caught) {
                this.addCaught(AttemptsBase.Category.CHECKED, caught);
            }
        }
        return this;
    }
}

