/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.arbitrary.mimas;

import java.math.BigInteger;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@FunctionalInterface
public interface Generator {
    public static Generator simple() {
        return Generator.simple(new Random());
    }

    public static Generator simple(Random random) {
        return numBits -> new BigInteger(numBits, random);
    }

    public BigInteger anyBits(int var1);

    default public boolean anyBoolean() {
        return this.anyBits(1).equals(BigInteger.ONE);
    }

    default public byte anyByte() {
        return this.anyBits(8).byteValue();
    }

    default public short anyShort() {
        return this.anyBits(16).shortValue();
    }

    default public int anyInt() {
        return this.anyBits(32).intValue();
    }

    default public int anyInt(int bound) {
        return this.anyBigInteger(BigInteger.valueOf(bound)).intValue();
    }

    default public int anyInt(int min, int bound) {
        return this.anyBigInteger(BigInteger.valueOf(min), BigInteger.valueOf(bound)).intValue();
    }

    default public long anyLong() {
        return this.anyBits(64).longValue();
    }

    default public long anyLong(long bound) {
        return this.anyBigInteger(BigInteger.valueOf(bound)).longValue();
    }

    default public long anyLong(long min, long bound) {
        return this.anyBigInteger(BigInteger.valueOf(min), BigInteger.valueOf(bound)).longValue();
    }

    default public float anyFloat() {
        float numerator = this.anyBits(24).floatValue();
        float denominator = BigInteger.ONE.shiftLeft(24).floatValue();
        return numerator / denominator;
    }

    default public double anyDouble() {
        double numerator = this.anyBits(53).doubleValue();
        double denominator = BigInteger.ONE.shiftLeft(53).doubleValue();
        return numerator / denominator;
    }

    default public char anyChar(String characters) {
        return characters.charAt(this.anyInt(characters.length()));
    }

    default public String anyString(int length, String characters) {
        if (0 <= length) {
            return IntStream.generate(() -> this.anyInt(characters.length())).limit(length).collect(StringBuilder::new, (sb, i) -> sb.append(characters.charAt(i)), StringBuilder::append).toString();
        }
        throw new IllegalArgumentException("<length> must be greater than or equal to zero but was " + length);
    }

    default public BigInteger anyBigInteger(BigInteger bound) {
        if (BigInteger.ZERO.compareTo(bound) < 0) {
            int bitLength = bound.bitLength();
            return Stream.generate(() -> this.anyBits(bitLength)).filter(result -> result.compareTo(bound) < 0).findAny().orElseThrow(NoSuchElementException::new);
        }
        throw new IllegalArgumentException("<bound> must be greater than ZERO but was " + bound);
    }

    default public BigInteger anyBigInteger(BigInteger min, BigInteger bound) {
        return this.anyBigInteger(bound.subtract(min)).add(min);
    }

    default public <T> T anyOf(T ... values) {
        return values[this.anyInt(values.length)];
    }

    default public <T extends Enum<T>> T anyOf(Class<T> enumClass) {
        return (T)((Enum)this.anyOf(enumClass.getEnumConstants()));
    }
}

