/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.arbitrary.mimas;

import de.team33.patterns.arbitrary.mimas.BitGenerator;
import java.math.BigInteger;
import java.util.function.ObjIntConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;

final class Generating {
    private static final int FLOAT_RESOLUTION = 24;
    private static final int DOUBLE_RESOLUTION = 53;

    private Generating() {
    }

    private static BigInteger anyBigInteger(BitGenerator generator, BigInteger bound, int bitLength) {
        if (BigInteger.ZERO.compareTo(bound) < 0) {
            return Stream.generate(() -> generator.anyBits(bitLength)).limit(16L).filter(result -> result.compareTo(bound) < 0).findAny().orElseGet(() -> generator.anyBits(bitLength - 1));
        }
        throw new IllegalArgumentException("<bound> must be greater than ZERO but was " + bound);
    }

    private static ObjIntConsumer<StringBuilder> sbAppender(String characters) {
        return (sb, index) -> sb.append(characters.charAt(index));
    }

    static boolean anyBoolean(BitGenerator generator) {
        return generator.anyBits(1).equals(BigInteger.ONE);
    }

    static byte anyByte(BitGenerator generator) {
        return generator.anyBits(8).byteValue();
    }

    static short anyShort(BitGenerator generator) {
        return generator.anyBits(16).shortValue();
    }

    static int anyInt(BitGenerator generator) {
        return generator.anyBits(32).intValue();
    }

    static int anyInt(BitGenerator generator, int bound) {
        return Generating.anyBigInteger(generator, BigInteger.valueOf(bound)).intValue();
    }

    static int anyInt(BitGenerator generator, int min, int bound) {
        return Generating.anyBigInteger(generator, BigInteger.valueOf(min), BigInteger.valueOf(bound)).intValue();
    }

    static int anySmallInt(BitGenerator generator, int bound) {
        return Generating.anySmallBigInteger(generator, BigInteger.valueOf(bound)).intValue();
    }

    static long anyLong(BitGenerator generator) {
        return generator.anyBits(64).longValue();
    }

    static long anyLong(BitGenerator generator, long bound) {
        return Generating.anyBigInteger(generator, BigInteger.valueOf(bound)).longValue();
    }

    static long anyLong(BitGenerator generator, long min, long bound) {
        return Generating.anyBigInteger(generator, BigInteger.valueOf(min), BigInteger.valueOf(bound)).longValue();
    }

    static float anyFloat(BitGenerator generator) {
        float numerator = generator.anyBits(24).floatValue();
        float denominator = BigInteger.ONE.shiftLeft(24).floatValue();
        return numerator / denominator;
    }

    static double anyDouble(BitGenerator generator) {
        double numerator = generator.anyBits(53).doubleValue();
        double denominator = BigInteger.ONE.shiftLeft(53).doubleValue();
        return numerator / denominator;
    }

    static BigInteger anyBigInteger(BitGenerator generator) {
        return BigInteger.valueOf(Generating.anyLong(generator));
    }

    static BigInteger anyBigInteger(BitGenerator generator, BigInteger bound) {
        return Generating.anyBigInteger(generator, bound, bound.bitLength());
    }

    static BigInteger anyBigInteger(BitGenerator generator, BigInteger min, BigInteger bound) {
        return Generating.anyBigInteger(generator, bound.subtract(min)).add(min);
    }

    static BigInteger anySmallBigInteger(BitGenerator generator) {
        return Generating.anySmallBigInteger(generator, BigInteger.ONE.shiftLeft(16));
    }

    static BigInteger anySmallBigInteger(BitGenerator generator, BigInteger bound) {
        return Generating.anyBigInteger(generator, bound, Generating.anyInt(generator, bound.bitLength()) + 1);
    }

    static <T> T anyOf(BitGenerator generator, T[] values) {
        return values[Generating.anyInt(generator, values.length)];
    }

    static char anyChar(BitGenerator generator, String characters) {
        return characters.charAt(Generating.anyInt(generator, characters.length()));
    }

    static char anyChar(BitGenerator generator) {
        return Generating.anyChar(generator, "0123456789_abcdefghijklmnopqrstuvwxyz-ABCDEFGHIJKLMNOPQRSTUVWXYZ !#$\u00a7%&*+,.?@\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df");
    }

    static String anyString(BitGenerator generator, int length, String characters) {
        if (0 > length) {
            throw new IllegalArgumentException("<length> must be greater than or equal to zero but was " + length);
        }
        if (characters.isEmpty()) {
            throw new IllegalArgumentException("<characters> must not be empty but was \"" + characters + "\"");
        }
        return IntStream.generate(() -> Generating.anyInt(generator, characters.length())).limit(length).collect(StringBuilder::new, Generating.sbAppender(characters), StringBuilder::append).toString();
    }

    public static String anyString(BitGenerator generator) {
        return Generating.anyString(generator, 1 + Generating.anyInt(generator, 128), "0123456789_abcdefghijklmnopqrstuvwxyz-ABCDEFGHIJKLMNOPQRSTUVWXYZ !#$\u00a7%&*+,.?@\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df");
    }
}

