/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.arbitrary.mimas;

import de.team33.patterns.arbitrary.mimas.Methods;
import de.team33.patterns.arbitrary.mimas.Types;
import de.team33.patterns.arbitrary.mimas.UnfitConditionException;
import de.team33.patterns.arbitrary.mimas.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class Supplying<S> {
    private static final Map<Class<?>, List<Method>> SUPPLIERS = new ConcurrentHashMap(0);
    private static final String METHOD_NOT_APPLICABLE = Util.load(Supplying.class, "supplierMethodNotApplicable.txt");
    final S source;
    final Class<?> sourceType;
    final Set<String> ignorable;
    final Predicate<Method> desired;
    private final List<Method> suppliers;

    Supplying(S source, Collection<String> ignore) {
        this.source = source;
        this.sourceType = source.getClass();
        this.suppliers = SUPPLIERS.computeIfAbsent(this.sourceType, Supplying::suppliers);
        this.ignorable = new HashSet<String>(ignore);
        this.desired = Supplying.nameFilter(this.ignorable).negate();
    }

    private static Predicate<Method> nameFilter(Set<String> names) {
        return method -> names.contains(method.getName());
    }

    private static List<Method> suppliers(Class<?> sourceType) {
        return Methods.publicGetters(sourceType).collect(Collectors.toList());
    }

    private Supplier<?> supplier(Method method) {
        return () -> {
            try {
                return method.invoke(this.source, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new UnfitConditionException(String.format(METHOD_NOT_APPLICABLE, this.sourceType, method.toGenericString(), method.getName()), e);
            }
        };
    }

    final Supplier<?> desiredSupplier(Type resultType, BinaryOperator<Method> preference) {
        return this.suppliers.stream().filter(supplier -> Types.isMatching(resultType, supplier.getGenericReturnType())).filter(this.desired).reduce(preference).map(this::supplier).orElse(null);
    }
}

