/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.arbitrary.mimas;

import de.team33.patterns.arbitrary.mimas.UnfitConditionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

final class Util {
    static final String STD_CHARACTERS = "0123456789_abcdefghijklmnopqrstuvwxyz-ABCDEFGHIJKLMNOPQRSTUVWXYZ !#$\u00a7%&*+,.?@\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df";
    static final long MAX_RETRY = 16L;
    static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private static final String NO_RESOURCE = "Should not happen: <%s> is not a valid resource or is not accessible in the context <%s>";

    private Util() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String load(Class<?> context, String resource) {
        try (InputStream in = context.getResourceAsStream(resource);){
            String string = Util.load(in);
            return string;
        }
        catch (IOException | RuntimeException e) {
            throw new UnfitConditionException(String.format(NO_RESOURCE, resource, context), e);
        }
    }

    private static String load(InputStream stream) throws IOException {
        try (InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            String string = Util.load(in);
            return string;
        }
    }

    private static String load(Reader reader) throws IOException {
        try (BufferedReader in = new BufferedReader(reader);){
            String string = in.lines().collect(Collectors.joining(NEWLINE));
            return string;
        }
    }
}

