/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.arbitrary.mimas;

import de.team33.patterns.arbitrary.mimas.BitGenerator;
import de.team33.patterns.arbitrary.mimas.Generating;
import java.math.BigInteger;
import java.util.Random;

@FunctionalInterface
public interface Generator
extends BitGenerator {
    public static BigInteger anyBits(int numBits, Random random) {
        return new BigInteger(numBits, random);
    }

    public static Generator of(Random random) {
        return numBits -> Generator.anyBits(numBits, random);
    }

    default public boolean anyBoolean() {
        return Generating.anyBoolean(this);
    }

    default public byte anyByte() {
        return Generating.anyByte(this);
    }

    default public short anyShort() {
        return Generating.anyShort(this);
    }

    default public int anyInt() {
        return Generating.anyInt(this);
    }

    default public int anyInt(int bound) {
        return Generating.anyInt(this, bound);
    }

    default public int anyInt(int min, int bound) {
        return Generating.anyInt(this, min, bound);
    }

    default public int anySmallInt(int bound) {
        return Generating.anySmallInt(this, bound);
    }

    default public long anyLong() {
        return Generating.anyLong(this);
    }

    default public long anyLong(long bound) {
        return Generating.anyLong(this, bound);
    }

    default public long anyLong(long min, long bound) {
        return Generating.anyLong(this, min, bound);
    }

    default public float anyFloat() {
        return Generating.anyFloat(this);
    }

    default public double anyDouble() {
        return Generating.anyDouble(this);
    }

    default public BigInteger anyBigInteger() {
        return Generating.anyBigInteger(this);
    }

    default public BigInteger anyBigInteger(BigInteger bound) {
        return Generating.anyBigInteger(this, bound);
    }

    default public BigInteger anyBigInteger(BigInteger min, BigInteger bound) {
        return Generating.anyBigInteger((BitGenerator)this, min, bound);
    }

    default public BigInteger anySmallBigInteger() {
        return Generating.anySmallBigInteger(this);
    }

    default public BigInteger anySmallBigInteger(BigInteger bound) {
        return Generating.anySmallBigInteger(this, bound);
    }

    default public char anyChar() {
        return Generating.anyChar(this);
    }

    default public char anyChar(String characters) {
        return Generating.anyChar(this, characters);
    }

    default public String anyString(int length, String characters) {
        return Generating.anyString(this, length, characters);
    }

    default public String anyString() {
        return Generating.anyString(this);
    }

    default public <T> T anyOf(T ... values) {
        return Generating.anyOf(this, values);
    }

    default public <T extends Enum<T>> T anyOf(Class<T> enumClass) {
        return (T)Generating.anyOf(this, (Enum[])enumClass.getEnumConstants());
    }
}

