/*
 * Decompiled with CFR 0.152.
 */
package de.team33.patterns.arbitrary.mimas;

import de.team33.patterns.arbitrary.mimas.UnfitConditionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

final class Util {
    static final String STD_CHARACTERS = "0123456789_abcdefghijklmnopqrstuvwxyz-ABCDEFGHIJKLMNOPQRSTUVWXYZ !#$\u00a7%&*+,.?@\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df";
    static final long MAX_RETRY = 16L;
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private static final String NO_RESOURCE = "Should not happen: <%s> is not a valid resource or is not accessible in the context <%s>";

    private Util() {
    }

    static String load(Class<?> context, String resource) {
        String string;
        block8: {
            InputStream in = context.getResourceAsStream(resource);
            try {
                string = Util.load(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    throw new UnfitConditionException(String.format(NO_RESOURCE, resource, context), e);
                }
            }
            in.close();
        }
        return string;
    }

    private static String load(InputStream stream) throws IOException {
        try (InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            String string = Util.load(in);
            return string;
        }
    }

    private static String load(Reader reader) throws IOException {
        try (BufferedReader in = new BufferedReader(reader);){
            String string = in.lines().collect(Collectors.joining(NEWLINE));
            return string;
        }
    }
}

